/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.utils.qrcode20;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNota;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;

public abstract class NFGeraQRCode20 {
    public static final String VERSAO_QRCODE = "2";
    protected final NFNota nota;
    protected final NFeConfig config;

    public NFGeraQRCode20(NFNota nFNota, NFeConfig nFeConfig) {
        this.nota = nFNota;
        this.config = nFeConfig;
    }

    public abstract String getQRCode() throws NoSuchAlgorithmException;

    public String getUrlQRCode() {
        String string;
        String string2 = string = this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getQrCodeProducao() : this.nota.getInfo().getIdentificacao().getUf().getQrCodeHomologacao();
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("URL para consulta do QRCode nao informada para uf " + String.valueOf((Object)this.nota.getInfo().getIdentificacao().getUf()) + "!");
        }
        if (StringUtils.isBlank((CharSequence)this.config.getCodigoSegurancaContribuinte())) {
            throw new IllegalArgumentException("CSC nao informado nas configuracoes!");
        }
        if (this.config.getCodigoSegurancaContribuinteID() == null || this.config.getCodigoSegurancaContribuinteID() == 0) {
            throw new IllegalArgumentException("IdCSC nao informado nas configuracoes!");
        }
        return string;
    }

    public static String createHash(String string, String string2) throws NoSuchAlgorithmException {
        return NFGeraQRCode20.sha1(string + string2);
    }

    public static String toHex(String string) {
        return String.format("%040x", new BigInteger(1, string.getBytes(Charset.forName("UTF-8"))));
    }

    public static String sha1(String string) throws NoSuchAlgorithmException {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : MessageDigest.getInstance("SHA1").digest(string.getBytes(Charset.forName("UTF-8")))) {
            stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
        }
        return stringBuilder.toString().toUpperCase();
    }

    public String urlConsultaChaveAcesso() {
        return this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO) ? this.nota.getInfo().getIdentificacao().getUf().getConsultaChaveAcessoProducao() : this.nota.getInfo().getIdentificacao().getUf().getConsultaChaveAcessoHomologacao();
    }
}

