/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.validadores;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class DFBigDecimalValidador {
    public static String tamanho11Com3CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.000", 12, 3, string);
    }

    public static String tamanho13Com2CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.00", 13, 2, string);
    }

    public static String tamanho15Com2CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.00", 16, 2, string);
    }

    public static String tamanho15Com3CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.000", 16, 3, string);
    }

    public static String tamanho15Com4CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.0000", 16, 4, string);
    }

    public static String tamanho11Com4CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.0000", 11, 4, string);
    }

    public static String tamanho21ComAte10CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.##########", 22, 10, string);
    }

    public static String tamanho15comAte4CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.####", 16, 4, string);
    }

    public static String tamanho15comAte6CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.######", 16, 6, string);
    }

    public static String tamanho5Com2CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.00", 7, 2, string);
    }

    public static String tamanho7ComAte4CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.00##", 8, 4, string);
    }

    public static String tamanho16ComAte4CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.####", 17, 4, string);
    }

    public static String tamanho16Com4CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.0000", 17, 4, string);
    }

    public static String tamanho9Com4CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.0000", 10, 4, string);
    }

    public static String tamanho4Com2CasasDecimais(BigDecimal bigDecimal, String string) {
        return DFBigDecimalValidador.parse(bigDecimal, "0.00", 5, 2, string);
    }

    public static String validaTamanho(BigDecimal bigDecimal, String string, Integer n, Integer n2, Boolean bl) {
        bigDecimal = (BigDecimal)ObjectUtils.defaultIfNull((Object)bigDecimal, (Object)BigDecimal.ZERO);
        n = (Integer)ObjectUtils.defaultIfNull((Object)n, (Object)12);
        n2 = (Integer)ObjectUtils.defaultIfNull((Object)n2, (Object)2);
        bl = (Boolean)ObjectUtils.defaultIfNull((Object)bl, (Object)false);
        return DFBigDecimalValidador.parse(bigDecimal, StringUtils.rightPad((String)"0.", (int)(n2 + 2), (String)(bl != false ? "0" : "#")), n, n2, string);
    }

    private static String parse(BigDecimal bigDecimal, String string, int n, int n2, String string2) {
        if (bigDecimal == null) {
            return null;
        }
        if (bigDecimal.toPlainString().length() > n || StringUtils.split((String)bigDecimal.toPlainString(), (String)".")[0].length() > n - (n2 + 1) || bigDecimal.scale() > n2) {
            throw new NumberFormatException(String.format("Valor %s extrapolou o tamanho de casas", string2));
        }
        bigDecimal = bigDecimal.round(new MathContext(bigDecimal.precision(), RoundingMode.UNNECESSARY));
        return new DecimalFormat(string, DecimalFormatSymbols.getInstance(Locale.US)).format(bigDecimal);
    }
}

