/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.validadores;

import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class DFStringValidador {
    public static void mmaaaa(String string) {
        if (string != null) {
            try {
                DateTimeFormatter.ofPattern("mm/yyyy").parse(string);
            }
            catch (Exception exception) {
                throw new IllegalStateException(String.format("Formato invalido (mm/aaaa) (%s)", string));
            }
        }
    }

    public static void aamm(String string) {
        if (string != null) {
            try {
                DateTimeFormatter.ofPattern("yymm").parse(string);
            }
            catch (Exception exception) {
                throw new IllegalStateException(String.format("Formato invalido (aamm) (%s)", string));
            }
        }
    }

    public static void codigoDeBarras(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([0-9]{0}|[0-9]{8}|[0-9]{12,14}|SEM GTIN)$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Codigo de barras com formato invalido (%s)", string));
        }
    }

    public static void telefone(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^[0-9]{6,14}$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Telefone de tamanho invalido (%s)", string));
        }
    }

    public static String telefone(String string, String string2) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^[0-9]{6,14}$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Telefone de tamanho invalido (%s) em %s", string, string2));
        }
        return string;
    }

    public static void email(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([_a-zA-Z0-9-]+(\\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*(\\.[a-zA-Z]{1,6}))?$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Email invalido (%s)", string));
        }
    }

    public static String email(String string, String string2) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([_a-zA-Z0-9-]+(\\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*(\\.[a-zA-Z]{1,6}))?$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Email invalido (%s) em %s", string, string2));
        }
        return string;
    }

    public static void tamanho256(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 256, string2);
        }
    }

    public static void tamanho9(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 9, string2);
        }
    }

    public static void tamanho60(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 60, string2);
        }
    }

    public static void tamanho1ate8(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 1, 8, string2);
        }
    }

    public static void tamanho2ate60(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 60, string2);
        }
    }

    public static void tamanho2ate40(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 40, string2);
        }
    }

    public static void tamanho2ate255(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 255, string2);
        }
    }

    public static void tamanho2ate2000(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 2000, string2);
        }
    }

    public static void tamanho25ate250(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 25, 250, string2);
        }
    }

    public static void tamanho22(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 22, string2);
        }
    }

    public static void tamanho21(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 21, string2);
        }
    }

    public static void tamanho20(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 20, string2);
        }
    }

    public static void tamanho20N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.tamanho20(string, string2);
        }
    }

    public static void tamanho2000(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 2000, string2);
        }
    }

    public static void tamanho5000(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 5000, string2);
        }
    }

    public static void tamanho40(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 40, string2);
        }
    }

    public static void placaDeVeiculo(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([A-Z]{2,3}[0-9]{4}|[A-Z]{3,4}[0-9]{3}|[A-Z]{3}[0-9][A-Z][0-9]{2})$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Placa de veiculo nao esta no padrao (%s)", string));
        }
    }

    public static void placaDeVeiculo(String string, String string2) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([A-Z]{2,3}[0-9]{4}|[A-Z]{3,4}[0-9]{3}|[A-Z]{3}[0-9][A-Z][0-9]{2})$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("%s nao esta no padrao (%s)", string2, string));
        }
    }

    public static void cnpj(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^[0-9]{14}$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Formato CNPJ Invalido (%s)", string));
        }
    }

    public static String cnpj(String string, String string2) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^[0-9]{14}$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Formato CNPJ Invalido (%s) em %s", string, string2));
        }
        return string;
    }

    public static void cpf(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^[0-9]{11}$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Formato CPF Invalido (%s)", string));
        }
    }

    public static String cpf(String string, String string2) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^[0-9]{11}$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Formato CPF Invalido (%s) em %s", string, string2));
        }
        return string;
    }

    public static void inscricaoEstadual(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^(ISENTO|[0-9]{2,14}|)$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Inscricao estadual invalido (%s)", string));
        }
    }

    public static void inscricaoEstadualSemIsencao(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([0-9]{2,14}|)$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Inscricao estadual invalido (%s)", string));
        }
    }

    public static String inscricaoEstadualSemIsencao(String string, String string2) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([0-9]{2,14}|)$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Inscricao estadual invalido (%s) em %s", string, string2));
        }
        return string;
    }

    public static void exatamente3(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 3, string2);
        }
    }

    public static void exatamente5(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 5, string2);
        }
    }

    public static void exatamente9(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 9, string2);
        }
    }

    public static void exatamente9N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoExato(string, 9, string2);
        }
    }

    public static void exatamente17(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 17, string2);
        }
    }

    public static void exatamente4(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 4, string2);
        }
    }

    public static void exatamente6(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 6, string2);
        }
    }

    public static void exatamente21(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 21, string2);
        }
    }

    public static void exatamente1(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 1, string2);
        }
    }

    public static void exatamente13(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 13, string2);
        }
    }

    public static void exatamente14(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 14, string2);
        }
    }

    public static void codigoProdutoAnvisa(String string, String string2) {
        if (string != null) {
            if (string.toUpperCase().matches("[A-Z]*")) {
                if (!Objects.equals(string.toUpperCase(), "ISENTO")) {
                    throw new IllegalStateException(String.format("C\u00f3digo produto anvisa (%s) diferente de ISENTO", string));
                }
            } else if (string.length() <= 11) {
                DFStringValidador.validaTamanhoExato(string, 11, string2);
            } else {
                DFStringValidador.validaTamanhoExato(string, 13, string2);
            }
        }
    }

    public static void tamanho15(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 15, string2);
        }
    }

    public static void tamanho12(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 12, string2);
        }
    }

    public static void tamanho12N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 12, string2);
        }
    }

    public static void tamanho120(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 120, string2);
        }
    }

    public static void tamanho128(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 128, string2);
        }
    }

    public static void tamanho160(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 160, string2);
        }
    }

    public static void tamanho10(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 10, string2);
        }
    }

    public static void tamanho10N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 10, string2);
        }
    }

    public static void tamanho100(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 100, string2);
        }
    }

    public static void tamanho6(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 6, string2);
        }
    }

    public static void tamanho6N(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 6, string2);
        }
    }

    public static void tamanho500(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 500, string2);
        }
    }

    public static void tamanho3(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 3, string2);
        }
    }

    public static void exatamente7(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 7, string2);
        }
    }

    public static void exatamente8(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 8, string2);
        }
    }

    public static void exatamente8N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoExato(string, 8, string2);
        }
    }

    public static void exatamente2(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 2, string2);
        }
    }

    public static void exatamente2N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoExato(string, 2, string2);
        }
    }

    public static void tamanho8a9(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 8, 9, string2);
        }
    }

    public static void tamanho15a256(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 15, 256, string2);
        }
    }

    public static void tamanho15a255(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 15, 255, string2);
        }
    }

    public static void tamanho5a20(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 5, 20, string2);
        }
    }

    public static void tamanho5a14(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 5, 14, string2);
        }
    }

    public static void tamanho5a60(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 5, 60, string2);
        }
    }

    public static void tamanho4a60(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 4, 60, string2);
        }
    }

    public static void tamanho2a4(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 4, string2);
        }
    }

    public static void tamanho2a9N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.intervalo(string, 2, 9, string2);
        }
    }

    public static void tamanho8a9N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.intervalo(string, 8, 9, string2);
        }
    }

    public static void tamanho15a1000(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 15, 1000, string2);
        }
    }

    public static void tamanho100a600(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 100, 600, string2);
        }
    }

    public static void tamanho60a1000(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 60, 1000, string2);
        }
    }

    public static void tamanho2a95(String string, String string2) {
        if (string != null) {
            DFStringValidador.intervalo(string, 2, 95, string2);
        }
    }

    public static void tamanho30(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 30, string2);
        }
    }

    public static void exatamente44(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoExato(string, 44, string2);
        }
    }

    public static void exatamente7N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.exatamente7(string, string2);
        }
    }

    public static void exatamente44N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.exatamente44(string, string2);
        }
    }

    public static void exatamente4N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.exatamente4(string, string2);
        }
    }

    public static void exatamente6N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.exatamente6(string, string2);
        }
    }

    public static void tamanho15N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 15, string2);
        }
    }

    public static void tamanho14N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 14, string2);
        }
    }

    public static void tamanho4(String string, String string2) {
        if (string != null) {
            DFStringValidador.validaTamanhoMaximo(string, 4, string2);
        }
    }

    public static void tamanho4N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 4, string2);
        }
    }

    public static void tamanho9N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 9, string2);
        }
    }

    public static void tamanho2ou3N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.intervalo(string, 2, 3, string2);
        }
    }

    public static void tamanho3N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 3, string2);
        }
    }

    public static void tamanho2N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 2, string2);
        }
    }

    public static void exatamente20N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoExato(string, 20, string2);
        }
    }

    public static void tamanho25N(String string, String string2) {
        if (string != null) {
            DFStringValidador.apenasNumerico(string, string2);
            DFStringValidador.validaTamanhoMaximo(string, 25, string2);
        }
    }

    public static String validador(String string, String string2, Integer n, Boolean bl, Boolean bl2) {
        n = (Integer)ObjectUtils.defaultIfNull((Object)n, (Object)1);
        bl = (Boolean)ObjectUtils.defaultIfNull((Object)bl, (Object)false);
        bl2 = (Boolean)ObjectUtils.defaultIfNull((Object)bl2, (Object)true);
        if (string != null) {
            if (bl2.booleanValue()) {
                DFStringValidador.apenasNumerico(string, string2);
            }
            if (bl.booleanValue()) {
                DFStringValidador.validaTamanhoExato(string, n, string2);
            } else {
                DFStringValidador.validaTamanhoMaximo(string, n, string2);
            }
        }
        return string;
    }

    public static String validador(String string, String string2, Integer n, Boolean bl) {
        return DFStringValidador.validador(string, string2, n, bl, null);
    }

    public static String validador(String string, String string2, Integer n) {
        return DFStringValidador.validador(string, string2, n, null, null);
    }

    public static void fci(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([A-F0-9]{8}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{4}-[A-F0-9]{12})$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("FCI fora do padrao (%s)", string));
        }
    }

    public static void ncm(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^([0-9]{2}|[0-9]{8})$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("NCM fora do padrao (%s)", string));
        }
    }

    private static void apenasNumerico(String string, String string2) {
        if (string != null && !StringUtils.isNumeric((CharSequence)string)) {
            throw new IllegalStateException(String.format("A string %s precisa ser numerica (%s)", string2, string));
        }
    }

    public static void validaTamanhoMaximo(String string, int n, String string2) {
        if (string != null && (string.length() < 1 || string.length() > n)) {
            throw new IllegalStateException(String.format("%s \"%s\" deve possuir entre 1-%s caracteres", string2, string, n));
        }
    }

    private static void validaTamanhoExato(String string, int n, String string2) {
        if (string != null && string.length() != n) {
            throw new IllegalStateException(String.format("%s \"%s\" deve possuir %s caracteres", string2, string, n));
        }
    }

    private static void intervalo(String string, int n, int n2, String string2) {
        if (string != null && (string.length() < n || string.length() > n2)) {
            throw new IllegalStateException(String.format("%s \"%s\" deve possuir entre %s-%s caracteres", string2, string, n, n2));
        }
    }

    public static String validaIntervalo(String string, int n, int n2, String string2) {
        return DFStringValidador.validaIntervalo(string, n, n2, string2, false);
    }

    public static String validaIntervalo(String string, int n, int n2, String string2, Boolean bl) {
        if (string != null) {
            if ((bl = (Boolean)ObjectUtils.defaultIfNull((Object)bl, (Object)false)).booleanValue()) {
                DFStringValidador.apenasNumerico(string, string2);
            }
            DFStringValidador.intervalo(string, n, n2, string2);
        }
        return string;
    }

    public static String capacidadeNDigitos(String string, String string2, int n) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^(0|[1-9]{1}[0-9]{0," + n + "})$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("%s fora do padrao (%s)", string2, string));
        }
        return string;
    }

    public static void nve(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^[A-Z]{2}[0-9]{4}$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("NVE fora do padrao (%s)", string));
        }
    }

    public static void itemListaServico(String string) {
        Matcher matcher;
        if (string != null && !(matcher = Pattern.compile("^\\d{2}\\.\\d{2}$").matcher(string)).find()) {
            throw new IllegalStateException(String.format("Item Lista de servico fora do padrao (%s)", string));
        }
    }

    public static void exatamente54(String string, String string2) {
        DFStringValidador.validaTamanhoExato(string, 54, string2);
    }

    public static void exatamente55(String string, String string2) {
        DFStringValidador.validaTamanhoExato(string, 55, string2);
    }

    public static void exatamente15N(String string, String string2) {
        DFStringValidador.validaTamanhoExato(string, 15, string2);
        DFStringValidador.apenasNumerico(string, string2);
    }

    public static void exatamente11N(String string, String string2) {
        DFStringValidador.apenasNumerico(string, string2);
        DFStringValidador.validaTamanhoExato(string, 11, string2);
    }

    public static void modeloDocumentoFiscal(String string) {
        if (!string.equals("55") && !string.equals("65")) {
            throw new IllegalStateException(String.format("Modelo Fiscal Invalido (%s)", string));
        }
    }

    public static void identificador(String string) {
        Matcher matcher = Pattern.compile("^ID\\d{41}$").matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException(String.format("Identificador fora do padrao (%s)", string));
        }
    }

    public static void identificadorCTe(String string) {
        Matcher matcher = Pattern.compile("^ID\\d{39}$").matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException(String.format("Identificador fora do padrao (%s)", string));
        }
    }

    public static void equals(String string, String string2) {
        if (!StringUtils.equals((CharSequence)string, (CharSequence)string2)) {
            throw new IllegalStateException(String.format("Valor('%s') nao corresponde com o padrao('%s')", string2, string));
        }
    }

    public static void isBase64(String string, String string2) {
        if (!Base64.isArrayByteBase64((byte[])string.getBytes())) {
            throw new IllegalStateException(String.format("A string %s com o valor = '%s' precisa ser codificada em Base64. ", string2, string));
        }
    }

    public static void validaCodigoRandomico(String string, String string2) {
        CharSequence[] charSequenceArray = new String[]{"00000000", "11111111", "22222222", "33333333", "44444444", "55555555", "66666666", "77777777", "88888888", "99999999", "12345678", "23456789", "34567890", "45678901", "56789012", "67890123", "78901234", "89012345", "90123456", "01234567"};
        if (StringUtils.containsAny((CharSequence)string, (CharSequence[])charSequenceArray)) {
            throw new IllegalStateException(String.format("%s \"%s\" inv\u00e1lido", string2, string));
        }
    }

    public static void validaPreenchimentoDeMargemValorAgregado(NFNotaInfoItemImpostoICMS nFNotaInfoItemImpostoICMS) throws InvocationTargetException, IllegalAccessException {
        if (nFNotaInfoItemImpostoICMS != null) {
            for (Method method2 : nFNotaInfoItemImpostoICMS.getClass().getMethods()) {
                Object object;
                Class<?> clazz = method2.getReturnType();
                Method[] methodArray = clazz.getMethods();
                boolean bl = Arrays.stream(methodArray).anyMatch(method -> method.getReturnType().equals(NFNotaInfoItemModalidadeBCICMSST.class));
                if (!bl || (object = method2.invoke((Object)nFNotaInfoItemImpostoICMS, new Object[0])) == null) continue;
                Method method3 = Arrays.stream(methodArray).filter(method -> method.getReturnType().equals(NFNotaInfoItemModalidadeBCICMSST.class)).findAny().get();
                NFNotaInfoItemModalidadeBCICMSST nFNotaInfoItemModalidadeBCICMSST = (NFNotaInfoItemModalidadeBCICMSST)((Object)method3.invoke(object, new Object[0]));
                Method method4 = Arrays.stream(methodArray).filter(method -> method.getName().contains("getPercentualMargemValorAdicionadoICMSST")).findAny().orElse(null);
                String string = null;
                if (method4 != null) {
                    string = (String)method4.invoke(object, new Object[0]);
                }
                if (nFNotaInfoItemModalidadeBCICMSST != null && nFNotaInfoItemModalidadeBCICMSST.equals((Object)NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO) && StringUtils.isBlank((CharSequence)string)) {
                    throw new IllegalStateException("Informada modalidade de determinacao da BC da ST como MVA(modBCST=4) e nao informado o campo pMVAST!");
                }
                if (!StringUtils.isNotBlank(string) || nFNotaInfoItemModalidadeBCICMSST != null && nFNotaInfoItemModalidadeBCICMSST.equals((Object)NFNotaInfoItemModalidadeBCICMSST.MARGEM_VALOR_AGREGADO)) continue;
                throw new IllegalStateException(String.format("Informada modalidade de determinacao da BC da ST diferente de MVA(informado[%s]) e informado o campo pMVAST", nFNotaInfoItemModalidadeBCICMSST != null ? nFNotaInfoItemModalidadeBCICMSST.toString() : "modBCST<>4"));
            }
        }
    }
}

