/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.implementation.accesshelpers.ExponentialBackoffAccessHelper;
import com.azure.core.implementation.accesshelpers.FixedDelayAccessHelper;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ImplUtils {
    private static final HttpHeaderName RETRY_AFTER_MS_HEADER = HttpHeaderName.fromString("retry-after-ms");
    private static final HttpHeaderName X_MS_RETRY_AFTER_MS_HEADER = HttpHeaderName.fromString("x-ms-retry-after-ms");
    public static final int MAX_CACHE_SIZE = 10000;
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private static final ClientLogger LOGGER = new ClientLogger(ImplUtils.class);
    private static final byte ZERO = 0;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte EF = -17;
    private static final byte FE = -2;
    private static final byte FF = -1;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(\\S+)\\b", 2);

    public static Duration getRetryAfterFromHeaders(HttpHeaders headers, Supplier<OffsetDateTime> nowSupplier) {
        Duration retryDelay = ImplUtils.tryGetRetryDelay(headers, X_MS_RETRY_AFTER_MS_HEADER, ImplUtils::tryGetDelayMillis);
        if (retryDelay != null) {
            return retryDelay;
        }
        retryDelay = ImplUtils.tryGetRetryDelay(headers, RETRY_AFTER_MS_HEADER, ImplUtils::tryGetDelayMillis);
        if (retryDelay != null) {
            return retryDelay;
        }
        retryDelay = ImplUtils.tryGetRetryDelay(headers, HttpHeaderName.RETRY_AFTER, headerValue -> ImplUtils.tryParseLongOrDateTime(headerValue, nowSupplier));
        return retryDelay;
    }

    private static Duration tryGetRetryDelay(HttpHeaders headers, HttpHeaderName headerName, Function<String, Duration> delayParser) {
        String headerValue = headers.getValue(headerName);
        return CoreUtils.isNullOrEmpty(headerValue) ? null : delayParser.apply(headerValue);
    }

    private static Duration tryGetDelayMillis(String value) {
        long delayMillis = ImplUtils.tryParseLong(value);
        return delayMillis >= 0L ? Duration.ofMillis(delayMillis) : null;
    }

    private static Duration tryParseLongOrDateTime(String value, Supplier<OffsetDateTime> nowSupplier) {
        long delaySeconds;
        try {
            OffsetDateTime retryAfter = new DateTimeRfc1123(value).getDateTime();
            delaySeconds = nowSupplier.get().until(retryAfter, ChronoUnit.SECONDS);
        }
        catch (DateTimeException ex) {
            delaySeconds = ImplUtils.tryParseLong(value);
        }
        return delaySeconds >= 0L ? Duration.ofSeconds(delaySeconds) : null;
    }

    private static long tryParseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    public static void writeByteBufferToStream(ByteBuffer buffer, OutputStream stream) throws IOException {
        if (buffer.hasArray()) {
            stream.write(buffer.array(), buffer.position(), buffer.remaining());
            buffer.position(buffer.position() + buffer.remaining());
            return;
        }
        if (stream instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)stream;
            fileOutputStream.getChannel().write(buffer);
            return;
        }
        stream.write(FluxUtil.byteBufferToArray(buffer));
    }

    public static UrlBuilder parseUrl(URL url, boolean includeQuery) {
        UrlBuilder result = new UrlBuilder();
        if (url != null) {
            String query;
            String path;
            int port;
            String host;
            String protocol = url.getProtocol();
            if (protocol != null && !protocol.isEmpty()) {
                result.setScheme(protocol);
            }
            if ((host = url.getHost()) != null && !host.isEmpty()) {
                result.setHost(host);
            }
            if ((port = url.getPort()) != -1) {
                result.setPort(port);
            }
            if ((path = url.getPath()) != null && !path.isEmpty()) {
                result.setPath(path);
            }
            if ((query = url.getQuery()) != null && !query.isEmpty() && includeQuery) {
                result.setQuery(query);
            }
        }
        return result;
    }

    public static String bomAwareToString(byte[] bytes, int offset, int count, String contentType) {
        if (bytes == null) {
            return null;
        }
        if (count >= 3 && bytes[offset] == -17 && bytes[offset + 1] == -69 && bytes[offset + 2] == -65) {
            return new String(bytes, 3, bytes.length - 3, StandardCharsets.UTF_8);
        }
        if (count >= 4 && bytes[offset] == 0 && bytes[offset + 1] == 0 && bytes[offset + 2] == -2 && bytes[offset + 3] == -1) {
            return new String(bytes, 4, bytes.length - 4, UTF_32BE);
        }
        if (count >= 4 && bytes[offset] == -1 && bytes[offset + 1] == -2 && bytes[offset + 2] == 0 && bytes[offset + 3] == 0) {
            return new String(bytes, 4, bytes.length - 4, UTF_32LE);
        }
        if (count >= 2 && bytes[offset] == -2 && bytes[offset + 1] == -1) {
            return new String(bytes, 2, bytes.length - 2, StandardCharsets.UTF_16BE);
        }
        if (count >= 2 && bytes[offset] == -1 && bytes[offset + 1] == -2) {
            return new String(bytes, 2, bytes.length - 2, StandardCharsets.UTF_16LE);
        }
        if (!CoreUtils.isNullOrEmpty(contentType)) {
            try {
                Matcher charsetMatcher = CHARSET_PATTERN.matcher(contentType);
                if (charsetMatcher.find()) {
                    return new String(bytes, offset, count, Charset.forName(charsetMatcher.group(1)));
                }
                return new String(bytes, offset, count, StandardCharsets.UTF_8);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                return new String(bytes, offset, count, StandardCharsets.UTF_8);
            }
        }
        return new String(bytes, offset, count, StandardCharsets.UTF_8);
    }

    public static URL createUrl(String urlString) throws MalformedURLException {
        return new URL(urlString);
    }

    public static <T> Class<? extends T> getClassByName(String className) {
        Objects.requireNonNull(className, "'className' cannot be null");
        try {
            return Class.forName(className, false, ImplUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Class '" + className + "' is not found on the classpath.", e));
        }
    }

    public static RetryStrategy getRetryStrategyFromOptions(RetryOptions retryOptions) {
        Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        if (retryOptions.getExponentialBackoffOptions() != null) {
            return ExponentialBackoffAccessHelper.create(retryOptions.getExponentialBackoffOptions(), retryOptions.getShouldRetryCondition());
        }
        if (retryOptions.getFixedDelayOptions() != null) {
            return FixedDelayAccessHelper.create(retryOptions.getFixedDelayOptions(), retryOptions.getShouldRetryCondition());
        }
        throw new IllegalArgumentException("'retryOptions' didn't define any retry strategy options");
    }

    public static void fullyWriteBuffer(ByteBuffer buffer, WritableByteChannel channel) throws IOException {
        while (buffer.hasRemaining()) {
            channel.write(buffer);
        }
    }

    public static <E extends Throwable> void sneakyThrows(Throwable e) throws E {
        throw e;
    }

    public static <T> T getResultWithTimeout(Future<T> future, long timeoutInMillis) throws InterruptedException, ExecutionException, TimeoutException {
        Objects.requireNonNull(future, "'future' cannot be null.");
        if (timeoutInMillis <= 0L) {
            return future.get();
        }
        try {
            return future.get(timeoutInMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            ImplUtils.sneakyThrows(cause);
            throw e;
        }
    }

    public static Thread addShutdownHookSafely(Thread shutdownThread) {
        if (shutdownThread == null) {
            return null;
        }
        if (ShutdownHookAccessHelperHolder.shutdownHookAccessHelper) {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().addShutdownHook(shutdownThread);
                return null;
            });
        } else {
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }
        return shutdownThread;
    }

    public static void removeShutdownHookSafely(Thread shutdownThread) {
        if (shutdownThread == null) {
            return;
        }
        if (ShutdownHookAccessHelperHolder.shutdownHookAccessHelper) {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().removeShutdownHook(shutdownThread);
                return null;
            });
        } else {
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
        }
    }

    static boolean isShutdownHookAccessHelper() {
        return ShutdownHookAccessHelperHolder.shutdownHookAccessHelper;
    }

    static void setShutdownHookAccessHelper(boolean shutdownHookAccessHelper) {
        ShutdownHookAccessHelperHolder.shutdownHookAccessHelper = shutdownHookAccessHelper;
    }

    private ImplUtils() {
    }

    private static final class ShutdownHookAccessHelperHolder {
        private static boolean shutdownHookAccessHelper = Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("AZURE_ENABLE_SHUTDOWN_HOOK_WITH_PRIVILEGE"));

        private ShutdownHookAccessHelperHolder() {
        }
    }

    public static final class QueryParameterIterator
    implements Iterator<Map.Entry<String, String>> {
        private final String queryParameters;
        private final int queryParametersLength;
        private boolean done = false;
        private int position;

        public QueryParameterIterator(String queryParameters) {
            this.queryParameters = queryParameters;
            this.queryParametersLength = queryParameters.length();
            this.position = queryParameters.startsWith("?") ? 1 : 0;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Map.Entry<String, String> next() {
            char c;
            int nextPosition;
            if (this.done) {
                throw new NoSuchElementException();
            }
            for (nextPosition = this.position; nextPosition < this.queryParametersLength && (c = this.queryParameters.charAt(nextPosition)) != '='; ++nextPosition) {
                if (c != '&') continue;
                String key = this.queryParameters.substring(this.position, nextPosition);
                this.position = nextPosition + 1;
                return new AbstractMap.SimpleImmutableEntry<String, String>(key, "");
            }
            if (nextPosition == this.queryParametersLength) {
                this.done = true;
                return new AbstractMap.SimpleImmutableEntry<String, String>(this.queryParameters.substring(this.position), "");
            }
            String key = this.queryParameters.substring(this.position, nextPosition);
            this.position = nextPosition + 1;
            nextPosition = this.queryParameters.indexOf(38, this.position);
            String value = null;
            if (nextPosition == -1) {
                this.done = true;
                value = this.queryParameters.substring(this.position);
            } else {
                value = this.queryParameters.substring(this.position, nextPosition);
                this.position = nextPosition + 1;
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
        }
    }
}

