/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorai.openai;

import com.lilittlecat.chatgpt.offical.ChatGPT;
import com.touchcomp.basementorai.InputModelFactory;
import com.touchcomp.basementorai.listener.InputModelAIListener;
import com.touchcomp.basementorai.model.OutputAIModel;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorlogger.TLogger;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import okhttp3.OkHttpClient;

public class AIOpenaAIBuilder {
    private static AIOpenaAIBuilder instance;
    private ChatGPT chatGPT;
    private List<InputModelAIListener> listeners = new LinkedList<InputModelAIListener>();

    public static AIOpenaAIBuilder get() {
        if (instance == null) {
            instance = new AIOpenaAIBuilder();
        }
        return instance;
    }

    public boolean isConfigured() {
        return this.chatGPT != null;
    }

    public OutputAIModel ask(String question) throws ExceptionInvalidState {
        try {
            if (this.chatGPT == null) {
                throw new ExceptionInvalidState("E.ERP.0493.007", new Object[0]);
            }
            String response = this.chatGPT.ask(question);
            OutputAIModel out = new OutputAIModel();
            out.setResponse(response);
            out.setQuestion(question);
            if (question.length() > 150) {
                out.setResQuestion(question.substring(0, 150) + "...");
            } else {
                out.setResQuestion(question);
            }
            if (response.length() > 150) {
                out.setResResponse(response.substring(0, 150) + "...");
            } else {
                out.setResResponse(question);
            }
            this.listeners.forEach(i -> i.onResponse(out));
            return out;
        }
        catch (Exception e) {
            TLogger.get(this.getClass()).error((Throwable)e);
            throw new ExceptionInvalidState("E.GEN.000031", new Object[]{e.getMessage()});
        }
    }

    public void configure(Params params) {
        OkHttpClient client = new OkHttpClient.Builder().callTimeout(Duration.ofMinutes(2L)).readTimeout(Duration.ofMinutes(2L)).connectTimeout(Duration.ofMinutes(50L)).build();
        if (params.getHostProxy() != null && params.getHostProxy().trim().length() > 0) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(params.getHostProxy(), params.getPortProxy()));
            this.chatGPT = new ChatGPT(params.getApiKey(), proxy);
        } else {
            this.chatGPT = new ChatGPT(params.getApiKey(), client);
        }
    }

    public OutputAIModel askInput(Long id, String input) throws ExceptionInvalidState {
        input = new InputModelFactory().buildIt(id, input);
        OutputAIModel out = this.ask(input);
        out.setInputModelId(id);
        this.listeners.forEach(i -> i.onResponseInput(out));
        return out;
    }

    public void addListener(InputModelAIListener ai) {
        if (!this.listeners.contains(ai)) {
            this.listeners.add(ai);
        }
    }

    public void removeListener(InputModelAIListener ai) {
        this.listeners.remove(ai);
    }

    public static class Params {
        private String apiKey;
        private String hostProxy;
        private int portProxy;

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getHostProxy() {
            return this.hostProxy;
        }

        public void setHostProxy(String hostProxy) {
            this.hostProxy = hostProxy;
        }

        public int getPortProxy() {
            return this.portProxy;
        }

        public void setPortProxy(int portProxy) {
            this.portProxy = portProxy;
        }
    }
}

