/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorai.recommendation;

import com.touchcomp.basementorai.recommendation.model.ItemSimilar;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.model.file.FileDataModel;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.LogLikelihoodSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;

public class AIRecommendProductBuilder {
    private static AIRecommendProductBuilder instance;
    private GenericItemBasedRecommender recommender;

    private AIRecommendProductBuilder() {
    }

    public static AIRecommendProductBuilder getInstance() {
        if (instance == null) {
            instance = new AIRecommendProductBuilder();
        }
        return instance;
    }

    public void configure(File csvFileContent) throws ExceptionIO {
        try {
            FileDataModel model = new FileDataModel(csvFileContent);
            LogLikelihoodSimilarity similarity = new LogLikelihoodSimilarity((DataModel)model);
            this.recommender = new GenericItemBasedRecommender((DataModel)model, (ItemSimilarity)similarity);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    public boolean isConfigured() {
        return this.recommender != null;
    }

    public List<ItemSimilar> recommend(Long idProduct, int howMany) throws ExceptionInvalidData {
        LinkedList<ItemSimilar> ret = new LinkedList<ItemSimilar>();
        try {
            if (this.recommender == null) {
                throw new ExceptionInvalidData("E.ERP.1996.001", new Object[0]);
            }
            this.recommender.mostSimilarItems(idProduct.longValue(), howMany).forEach(item -> ret.add(new ItemSimilar((Long)item.getItemID(), Float.valueOf(item.getValue()))));
            return ret;
        }
        catch (NoSuchItemException ex) {
            return ret;
        }
        catch (TasteException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionInvalidData("E.ERP.1996.002", new Object[]{ex.getMessage(), ex});
        }
    }
}

