/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculo;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Arrays;
import java.util.List;

public class Icms51
extends BaseIcmsST
implements InterfaceIcmsCalculo {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        calc.setAliquotaIcms(params.getParamsCalcIcms().getAliquotaIcmsInformada());
        calc.setBaseCalculoIcms(baseCalculo);
        if (!ToolMethods.isWithData((Number)params.getParamsCalcIcms().getPercDiferimento())) {
            calc.setValorIcmsOutros(baseCalculo);
        } else {
            double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
            double valorIcmsTotal = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaIcms / 100.0)), (int)2);
            double valorIcms = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (aliquotaIcms / 100.0)), (int)2);
            double valorDiferimento = ToolFormatter.arrredondarNumero((Double)(valorIcms * (params.getParamsCalcIcms().getPercDiferimento() / 100.0)), (int)2);
            double percBaseCalculoTrib = ToolFormatter.arrredondarNumero((Double)((valorIcms -= valorDiferimento) * 100.0 / valorIcmsTotal), (int)4);
            double baseCalculoTrib = ToolFormatter.arrredondarNumero((Double)(baseCalculo * (percBaseCalculoTrib / 100.0)), (int)2);
            double baseCalculoOutros = ToolFormatter.arrredondarNumero((Double)(baseCalculo - baseCalculoTrib), (int)2);
            calc.setValorIcmsTributado(baseCalculoTrib);
            calc.setValorIcmsOutros(baseCalculoOutros);
            calc.setAliquotaIcms(aliquotaIcms);
            calc.setValorIcms(valorIcms);
            calc.setPercentualDiferimento(params.getParamsCalcIcms().getPercDiferimento());
            calc.setValorIcmsDiferido(valorDiferimento);
        }
        this.calcularFCP(params, calc);
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIcms> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIcms.DIFERIMENTO);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

