/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculo;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import java.util.Arrays;
import java.util.List;

public class Icms90
extends BaseIcmsST
implements InterfaceIcmsCalculo {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBCCalculoReducao(params);
        double bcAcess = this.getBCDespAcessorias(params);
        if (params.getParamsCalcIcms().getTipoAliquotaIcms() == EnumConstTipoAliquotaIcms.ALIQ_ICMS_SEM_INCIDENCIA) {
            this.calcularValoresDesoneracao(params, calc, baseCalculo, bcAcess, params.getParamsCalcIcms().getAliquotaIcmsInformada(), params.getParamsCalcIcms().getPercRedBCIcms());
            calc.setBaseCalculoIcms(baseCalculo);
            calc.setValorIcmsOutros(calc.getBaseCalculoIcms() - calc.getValorIcmsDispensado());
            calc.setAliquotaIcms(0.0);
            return calc;
        }
        double percRedBCICMS = params.getParamsCalcIcms().getPercRedBCIcms();
        if (percRedBCICMS > 0.0) {
            this.calcularValoresReducaoBCIcms(params, calc, baseCalculo, bcAcess, params.getParamsCalcIcms().getAliquotaIcmsInformada(), percRedBCICMS);
            this.calcularFCP(params, calc);
        } else {
            calc.setBaseCalculoIcms(baseCalculo);
            calc.setValorIcmsTributado(calc.getBaseCalculoIcms());
            calc.setValorIcms(this.calcIcms(calc.getBaseCalculoIcms(), params.getParamsCalcIcms().getAliquotaIcmsInformada(), params.getTipoArredondamento()));
            calc.setAliquotaIcms(params.getParamsCalcIcms().getAliquotaIcmsInformada());
            this.calcularFCP(params, calc);
        }
        if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.ENTRADA) {
            if (!this.isRecuperaTributos(params)) {
                calc.setValorIcmsOutros(calc.getBaseCalculoIcms());
                calc.setValorIcmsSemAprov(calc.getValorIcms());
                calc.setValorIcmsTributado(0.0);
                calc.setValorIcms(0.0);
            }
            this.calcularDiferencaAliquotaEntrada(params, calc);
        } else {
            this.calcularSt(params, calc);
            this.calcularFCPSt(params, calc);
            this.calcPartilhaIcms(params, calc);
        }
        calc.setBaseCalculoIcms(baseCalculo);
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIcms> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIcms.OUTROS);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

