/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculo;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import java.util.Arrays;
import java.util.List;

public class IcmsSimples900
extends BaseIcmsST
implements InterfaceIcmsCalculo {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        calc.setValorIcmsOutros(baseCalculo);
        if (params.getParamsCalcIcms().getCalcularIcmsSimples() == EnumConstantsMentorSimNao.SIM) {
            calc.setAliquotaIcmsSimples(params.getParamsCalcIcms().getAliquotaIcmsSimples());
            calc.setValorIcmsSimples(baseCalculo * (calc.getAliquotaIcmsSimples() / 100.0));
        }
        double aliquotaICMS = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        double percRedICMS = params.getParamsCalcIcms().getPercRedBCIcms();
        double bcAcess = this.getBCDespAcessorias(params);
        if (params.getParamsCalcIcms().getTipoAliquotaIcms() != EnumConstTipoAliquotaIcms.ALIQ_ICMS_SEM_INCIDENCIA) {
            if (percRedICMS > 0.0) {
                this.calcularValoresReducaoBCIcms(params, calc, baseCalculo, bcAcess, aliquotaICMS, percRedICMS);
                calc.setValorIcmsOutros(calc.getBaseCalculoIcms() + calc.getValorBCIcmsNaoTributado());
            } else {
                calc.setBaseCalculoIcms(baseCalculo);
                calc.setValorIcmsOutros(calc.getBaseCalculoIcms());
                calc.setValorIcms(this.calcIcms(baseCalculo, aliquotaICMS, params.getTipoArredondamento()));
                calc.setAliquotaIcms(aliquotaICMS);
            }
            this.calcularSt(params, calc);
        } else {
            calc.setBaseCalculoIcms(baseCalculo);
            calc.setValorIcmsOutros(baseCalculo);
            calc.setAliquotaIcms(0.0);
            calc.setValorIcms(0.0);
            Double valorIcms = this.arrredondarNumero(baseCalculo * (aliquotaICMS / 100.0), 2, params.getTipoArredondamento());
            this.calcularSt(params, calc, valorIcms);
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIcms> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIcms.SIMPLES_OUTROS);
    }

    @Override
    public boolean validCalcEntrada() {
        return false;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

