/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.inss;

import com.touchcomp.basementor.constants.enums.impostos.inss.EnumConstTipoCalcInss;
import com.touchcomp.basementorrules.impostos.inss.model.InssCalculado;
import com.touchcomp.basementorrules.impostos.inss.model.InssParams;

public class CompImpostoInss {
    public static InssCalculado calcularInss(InssParams params) {
        double valorInssNaoRetido;
        double valorInss;
        double baseCalculo = params.getBaseCalculo();
        InssCalculado calc = new InssCalculado(params);
        if (params.getTipoCalcInss() == EnumConstTipoCalcInss.CALCULAR_INSS_RETIDO || params.getTipoCalcInss() == EnumConstTipoCalcInss.CALCULAR_INSS_NAO_RETIDO) {
            double bcInss = 0.0;
            bcInss = params.getPercRedInss() > 0.0 ? baseCalculo - baseCalculo * (params.getPercRedInss() / 100.0) : baseCalculo;
            calc.setAliquotaInss(params.getAliquotaInss());
            calc.setPercRedInss(params.getPercRedInss());
            calc.setBaseCalculoInss(bcInss);
            if (params.getTipoCalcInss() == EnumConstTipoCalcInss.CALCULAR_INSS_RETIDO) {
                calc.setValorInss(params.getAliquotaInss() / 100.0 * bcInss);
                calc.setValorInssNaoRetido(0.0);
            } else {
                calc.setValorInssNaoRetido(params.getAliquotaInss() / 100.0 * bcInss);
                calc.setValorInss(0.0);
            }
        }
        if ((valorInss = calc.getValorInss().doubleValue()) < params.getValorMinimoInss()) {
            calc.setValorInss(0.0);
        }
        if ((valorInssNaoRetido = calc.getValorInssNaoRetido().doubleValue()) < params.getValorMinimoInss()) {
            calc.setValorInssNaoRetido(0.0);
        }
        return calc;
    }
}

