/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.iss;

import com.touchcomp.basementor.constants.enums.impostos.iss.EnumConstTipoCalcIss;
import com.touchcomp.basementorrules.impostos.iss.model.IssCalculado;
import com.touchcomp.basementorrules.impostos.iss.model.IssParams;

public class CompImpostoIss {
    public static IssCalculado calcularIss(IssParams params) {
        double baseCalculo = params.getBaseCalculo();
        EnumConstTipoCalcIss tipoISS = params.getTipoCalcIss();
        IssCalculado calc = new IssCalculado(params);
        if (tipoISS == EnumConstTipoCalcIss.CALCULAR_NORMAL || tipoISS == EnumConstTipoCalcIss.CALCULAR_RETIDO) {
            double bcIss = 0.0;
            bcIss = params.getPercRedIss() > 0.0 ? baseCalculo - baseCalculo * (params.getPercRedIss() / 100.0) : baseCalculo;
            calc.setAliquotaIss(params.getAliquotaIss());
            calc.setValorIss(params.getAliquotaIss() / 100.0 * bcIss);
            calc.setPercRedIss(params.getPercRedIss());
            calc.setBaseCalculoIss(bcIss);
        } else if (tipoISS == EnumConstTipoCalcIss.EXIBIR_ALIQ_NAO_CALC) {
            calc.setAliquotaIss(params.getAliquotaIss());
            calc.setValorIss(0.0);
            calc.setPercRedIss(params.getPercRedIss());
            calc.setBaseCalculoIss(baseCalculo);
        } else {
            calc.setAliquotaIss(params.getAliquotaIss());
            calc.setBaseCalculoIss(baseCalculo);
        }
        double valorIss = calc.getValorIss();
        if (valorIss < params.getValorMinimoIss()) {
            calc.setValorIss(0.0);
        }
        return calc;
    }
}

