/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.certificado;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class ToolCertificadoSocketUtil {
    public SSLContext createSSLContext(InputStream certificado, String senha) throws ExceptionCertificado {
        KeyManager[] keyManagers = this.createKeyManagers(certificado, senha);
        return this.createSSLContext(keyManagers);
    }

    public SSLContext createSSLContext(X509Certificate certificate, PrivateKey privateKey) throws ExceptionCertificado {
        KeyManager[] keyManagers = this.createKeyManagers(certificate, privateKey);
        return this.createSSLContext(keyManagers);
    }

    public SSLContext createSSLContext(KeyManager[] keyManagers) throws ExceptionCertificado {
        try {
            TrustManager[] trustManagers = this.createTrustManagersAll();
            String text = System.getProperty("jdk.tls.client.protocols");
            if (text == null || text.length() == 0) {
                text = "TLS";
            }
            SSLContext sslContext = SSLContext.getInstance(text);
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (KeyManagementException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (KeyStoreException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (CertificateException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (IOException ex) {
            throw new ExceptionCertificado(ex);
        }
    }

    public KeyManager[] createKeyManagers(X509Certificate certificate, PrivateKey privateKey) {
        HSKeyManager keyManager = new HSKeyManager(this, certificate, privateKey);
        return new KeyManager[]{keyManager};
    }

    public KeyManager[] createKeyManagers(InputStream certificado, String senha) throws ExceptionCertificado {
        try {
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(certificado, senha.toCharArray());
            String alias = "";
            Enumeration<String> aliasesEnum = ks.aliases();
            while (aliasesEnum.hasMoreElements() && !ks.isKeyEntry(alias = aliasesEnum.nextElement())) {
            }
            X509Certificate certificate = (X509Certificate)ks.getCertificate(alias);
            PrivateKey privateKey = (PrivateKey)ks.getKey(alias, senha.toCharArray());
            HSKeyManager keyManager = new HSKeyManager(this, certificate, privateKey);
            return new KeyManager[]{keyManager};
        }
        catch (KeyStoreException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (IOException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (CertificateException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new ExceptionCertificado(ex);
        }
    }

    public TrustManager[] createTrustManagersAll() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(this){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return trustAllCerts;
    }

    class HSKeyManager
    implements X509KeyManager {
        private X509Certificate certificate;
        private PrivateKey privateKey;

        public HSKeyManager(ToolCertificadoSocketUtil this$0, X509Certificate certificate, PrivateKey privateKey) {
            this.certificate = certificate;
            this.privateKey = privateKey;
        }

        @Override
        public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
            return this.certificate.getIssuerDN().getName();
        }

        @Override
        public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String arg0) {
            return new X509Certificate[]{this.certificate};
        }

        @Override
        public String[] getClientAliases(String arg0, Principal[] arg1) {
            return new String[]{this.certificate.getIssuerDN().getName()};
        }

        @Override
        public PrivateKey getPrivateKey(String arg0) {
            return this.privateKey;
        }

        @Override
        public String[] getServerAliases(String arg0, Principal[] arg1) {
            return null;
        }
    }
}

