/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.clone;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.CascadeType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.annotations.Cascade;

public class AuxCloneDTO<Z, T> {
    private final Class<Z> entityClass;
    private final T dto;

    public AuxCloneDTO(Class<Z> entityClass, T dto) {
        this.entityClass = entityClass;
        this.dto = dto;
    }

    public T cloneDTO() throws ExceptionReflection {
        try {
            Object cloned = this.cloneObj(this.dto);
            List<StringBuilder> pathMethods = this.getPathMethods(this.entityClass);
            this.setNull(cloned, pathMethods);
            return (T)cloned;
        }
        catch (InstantiationException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (IntrospectionException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
    }

    private List<StringBuilder> getPathMethods(Class<Z> entityClass) throws IntrospectionException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        LinkedList<StringBuilder> fields = new LinkedList<StringBuilder>();
        this.checkProperty(entityClass, new StringBuilder(), fields, true);
        return fields;
    }

    private void checkProperty(Class baseClass, StringBuilder path, List<StringBuilder> fields, boolean cascadePrev) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, IntrospectionException {
        PropertyDescriptor[] props;
        BeanInfo bInfo = Introspector.getBeanInfo(baseClass);
        for (PropertyDescriptor p : props = bInfo.getPropertyDescriptors()) {
            this.checkProperty(baseClass, p, path, fields, cascadePrev);
        }
    }

    private void checkProperty(Class baseClass, PropertyDescriptor p, StringBuilder path, List<StringBuilder> fields, boolean isCascadePrev) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, IntrospectionException {
        ManyToMany manyToMany;
        OneToOne oneToOne;
        ManyToOne manyToOne;
        OneToMany oneToMany;
        if (p.getReadMethod() == null || p.getWriteMethod() == null) {
            return;
        }
        Method read = p.getReadMethod();
        Field field = ToolReflections.getField(baseClass, p.getName());
        Cascade cascadeHibernate = null;
        CascadeType[] cascade = null;
        Id id = null;
        Version version = null;
        Class targetClass = null;
        if (read != null) {
            oneToMany = read.getAnnotation(OneToMany.class);
            manyToOne = read.getAnnotation(ManyToOne.class);
            oneToOne = read.getAnnotation(OneToOne.class);
            manyToMany = read.getAnnotation(ManyToMany.class);
            cascadeHibernate = read.getAnnotation(Cascade.class);
            id = p.getReadMethod().getAnnotation(Id.class);
            version = p.getReadMethod().getAnnotation(Version.class);
            if (oneToMany != null) {
                cascade = oneToMany.cascade();
                targetClass = this.getTargetEntity(oneToMany.targetEntity(), p.getReadMethod(), field);
            }
            if (manyToOne != null) {
                cascade = manyToOne.cascade();
                targetClass = this.getTargetEntity(manyToOne.targetEntity(), p.getReadMethod(), field);
            }
            if (oneToOne != null) {
                cascade = oneToOne.cascade();
                targetClass = this.getTargetEntity(oneToOne.targetEntity(), p.getReadMethod(), field);
            }
            if (manyToMany != null) {
                cascade = manyToMany.cascade();
                targetClass = this.getTargetEntity(manyToMany.targetEntity(), p.getReadMethod(), field);
            }
        }
        if (field != null) {
            oneToMany = field.getAnnotation(OneToMany.class);
            manyToOne = field.getAnnotation(ManyToOne.class);
            oneToOne = field.getAnnotation(OneToOne.class);
            manyToMany = field.getAnnotation(ManyToMany.class);
            if (oneToMany != null) {
                cascade = oneToMany.cascade();
            }
            if (manyToOne != null) {
                cascade = manyToOne.cascade();
            }
            if (oneToOne != null) {
                cascade = oneToOne.cascade();
            }
            if (manyToMany != null) {
                cascade = manyToMany.cascade();
            }
            if (field.getAnnotation(Id.class) != null) {
                id = field.getAnnotation(Id.class);
            }
            if (field.getAnnotation(Version.class) != null) {
                version = field.getAnnotation(Version.class);
            }
            if (field.getAnnotation(Cascade.class) != null) {
                cascadeHibernate = field.getAnnotation(Cascade.class);
            }
        }
        if (this.isCascade(cascade, cascadeHibernate) && field != null) {
            baseClass = this.getTargetEntity(targetClass, read, field);
            this.checkProperty(baseClass, new StringBuilder(String.valueOf(path) + field.getName() + "."), fields, isCascadePrev);
        }
        if (isCascadePrev && field != null && (id != null || version != null)) {
            fields.add(new StringBuilder(String.valueOf(path) + field.getName()));
        }
    }

    private boolean isCascade(CascadeType[] cascade, Cascade cascadeHibernate) {
        if (cascade != null) {
            if (Arrays.binarySearch(cascade, CascadeType.ALL) >= 0) {
                return true;
            }
            if (Arrays.binarySearch(cascade, CascadeType.MERGE) >= 0) {
                return true;
            }
            if (Arrays.binarySearch(cascade, CascadeType.PERSIST) >= 0) {
                return true;
            }
        }
        if (cascadeHibernate != null) {
            if (Arrays.binarySearch(cascadeHibernate.value(), org.hibernate.annotations.CascadeType.PERSIST) >= 0) {
                return true;
            }
            if (Arrays.binarySearch(cascadeHibernate.value(), org.hibernate.annotations.CascadeType.MERGE) >= 0) {
                return true;
            }
            if (Arrays.binarySearch(cascadeHibernate.value(), org.hibernate.annotations.CascadeType.SAVE_UPDATE) >= 0) {
                return true;
            }
            if (Arrays.binarySearch(cascadeHibernate.value(), org.hibernate.annotations.CascadeType.ALL) >= 0) {
                return true;
            }
        }
        return false;
    }

    private Class getTargetEntity(Class targetEntity, Method readMethod, Field field) {
        Class type;
        Type genericType;
        if (targetEntity != null && !targetEntity.getSimpleName().equalsIgnoreCase("void")) {
            return targetEntity;
        }
        if (readMethod != null) {
            if (!Collection.class.isAssignableFrom(readMethod.getReturnType())) {
                return readMethod.getReturnType();
            }
            genericType = readMethod.getGenericReturnType();
            type = ToolReflections.getGenericTypeClass((ParameterizedType)genericType, 0);
            if (type != null) {
                return type;
            }
        }
        if (field != null) {
            if (!Collection.class.isAssignableFrom(field.getType())) {
                return field.getType();
            }
            genericType = field.getGenericType();
            type = ToolReflections.getGenericTypeClass((ParameterizedType)genericType, 0);
            if (type != null) {
                return type;
            }
        }
        return null;
    }

    private void setNull(T cloned, List<StringBuilder> pathMethods) throws ExceptionReflection, InstantiationException, IllegalAccessException {
        for (StringBuilder pathMethod : pathMethods) {
            this.setNull(pathMethod.toString(), cloned);
        }
    }

    private void setNull(String sk, Object cloned) throws ExceptionReflection, InstantiationException, IllegalAccessException {
        String atual = sk;
        if (!TMethods.isStrWithData(sk)) {
            return;
        }
        if (atual.indexOf(".") > 0) {
            atual = atual.substring(0, atual.indexOf("."));
        }
        System.out.println(atual);
        Field f = ToolReflections.getField(cloned.getClass(), atual);
        if (f == null) {
            return;
        }
        Class<?> type = f.getType();
        if (ToolReflections.isPrimitive(type)) {
            Method writeMethod = ToolReflections.getWriteMethod(cloned.getClass(), atual);
            ToolReflections.setIt(writeMethod, cloned, new Object[]{null});
        } else if (Collection.class.isAssignableFrom(type)) {
            Collection data = (Collection)ToolReflections.getFieldValueFromGetMethod(atual, cloned);
            if (data != null) {
                Collection newest = (Collection)data.getClass().newInstance();
                sk = sk.substring(atual.length() + 1);
                for (Object object : data) {
                    Object aux = this.cloneObj(object);
                    newest.add(aux);
                    this.setNull(sk, aux);
                }
                Method writeMethod = ToolReflections.getWriteMethod(cloned.getClass(), atual);
                ToolReflections.setIt(writeMethod, cloned, newest);
            }
        } else {
            sk = sk.substring(atual.length() + 1);
            Object aux = ToolReflections.getFieldValueFromGetMethod(atual, cloned);
            if (aux != null) {
                aux = this.cloneObj(aux);
                Method writeMethod = ToolReflections.getWriteMethod(cloned.getClass(), atual);
                ToolReflections.setIt(writeMethod, cloned, aux);
                this.setNull(sk, aux);
            }
        }
    }

    private void setNull(StringTokenizer sk, Field f, Class type, T cloned) {
    }

    private Object cloneObj(Object aux) throws ExceptionReflection {
        try {
            return BeanUtils.cloneBean((Object)aux);
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InstantiationException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionReflection(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ExceptionReflection(ex);
        }
    }
}

