/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.converter.impl;

import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.converter.impl.RestrictionOption;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class DoubleOpFinder
implements OpFinder<Double> {
    private Format format;

    public DoubleOpFinder() {
        this.format = NumberFormat.getNumberInstance();
        ((NumberFormat)this.format).setMinimumFractionDigits(2);
    }

    public DoubleOpFinder(Format format) {
        this.format = format;
    }

    @Override
    public List<RestrictionOption> getRestrictions() {
        ArrayList<RestrictionOption> rest = new ArrayList<RestrictionOption>();
        RestrictionOption opt = null;
        opt = new RestrictionOption();
        opt.setDescription("Igual a");
        opt.setRestriction(EnumConstantsCriteria.EQUAL);
        rest.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Diferente de");
        opt.setRestriction(EnumConstantsCriteria.NOT_EQUAL);
        rest.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Maior que");
        opt.setRestriction(EnumConstantsCriteria.GREATER);
        rest.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Maior igual a");
        opt.setRestriction(EnumConstantsCriteria.GREATER_EQUAL);
        rest.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Menor que");
        opt.setRestriction(EnumConstantsCriteria.LESS);
        rest.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Menor igual ");
        opt.setRestriction(EnumConstantsCriteria.LESS_EQUAL);
        rest.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Entre");
        opt.setRestriction(EnumConstantsCriteria.BETWEEN);
        rest.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Nulo");
        opt.setRestriction(EnumConstantsCriteria.IS_NULL);
        rest.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Nao Nulo");
        opt.setRestriction(EnumConstantsCriteria.IS_NOT_NULL);
        rest.add(opt);
        return rest;
    }

    @Override
    public Format getFormatter() {
        return this.format;
    }

    @Override
    public void setFormatter(Format format) {
        this.format = format;
    }

    @Override
    public Double getDefaultValue() {
        return 0.0;
    }

    @Override
    public Double convertValue(String value) {
        if (value == null || "null".equalsIgnoreCase(value) || value.trim().length() == 0) {
            return null;
        }
        return Double.valueOf(value);
    }

    @Override
    public Double convertStrNativeValue(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        return Double.valueOf(value);
    }

    @Override
    public String convertValueToString(Double value) {
        if (value == null) {
            return null;
        }
        return this.getFormatter().format(value);
    }

    @Override
    public String convertValueToStringNative(Double value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Class getConverterClass() {
        return Double.class;
    }

    @Override
    public String getDefaultValueStr() {
        return this.convertValueToString(this.getDefaultValue());
    }

    @Override
    public String getDefaultValueStrNative() {
        return this.convertValueToStringNative(this.getDefaultValue());
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return false;
        }
        return this.getConverterClass().isAssignableFrom(value.getClass());
    }
}

