/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.excel.impl.write;

import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementortools.tools.excel.model.ExcelCellType;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.excel.model.ExcelType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelXLSXWrite {
    private OutputStream outputStream;
    private ExcelType type;
    private int startLine = 0;
    public static final int START_LINE_DEFAULT = 0;

    public ExcelXLSXWrite(OutputStream inputStream, ExcelType type) {
        this.outputStream = inputStream;
        this.type = type;
    }

    public ExcelXLSXWrite(File file) throws FileNotFoundException {
        this.type = file.getName().toLowerCase().endsWith(ExcelType.XLS.getFileExt()) ? ExcelType.XLS : ExcelType.XLSX;
        this.outputStream = new FileOutputStream(file);
    }

    public ExcelXLSXWrite(String file) throws FileNotFoundException {
        this(new File(file));
    }

    public void write(ExcelSheet ex) throws IOException, ExceptionParseObject {
        try (Workbook workbook = this.getWorkBook();){
            Sheet sheet = workbook.createSheet(ex.getName());
            for (ExcelSheet.Row row : ex.getRows()) {
                Row r = sheet.createRow(row.getIndex());
                for (ExcelSheet.Cell cell : row.getCells()) {
                    if (cell == null) continue;
                    ExcelCellType type = cell.getType();
                    if (type == null) {
                        type = ExcelCellType.STRING;
                    }
                    switch (type) {
                        case BOOLEAN: {
                            r.createCell(cell.getIndex()).setCellValue(Boolean.parseBoolean(cell.asString()));
                            break;
                        }
                        case NUMERIC: {
                            r.createCell(cell.getIndex()).setCellValue(cell.asDoubleWrite());
                            break;
                        }
                        case STRING: {
                            r.createCell(cell.getIndex()).setCellValue(cell.asString());
                            break;
                        }
                        case BLANK: {
                            r.createCell(cell.getIndex()).setCellValue(cell.asString());
                            break;
                        }
                        case ERROR: {
                            r.createCell(cell.getIndex()).setCellValue(cell.asString());
                            break;
                        }
                        case FORMULA: {
                            Cell data = r.createCell(cell.getIndex());
                            data.setCellValue(cell.asString());
                            break;
                        }
                        case DATE: {
                            CellStyle cellStyle = workbook.createCellStyle();
                            CreationHelper createHelper = workbook.getCreationHelper();
                            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat("dd/mm/yyyy hh.mm;@"));
                            Cell data = r.createCell(cell.getIndex());
                            data.setCellValue(cell.asDate());
                            data.setCellStyle(cellStyle);
                            break;
                        }
                    }
                }
            }
            workbook.write(this.outputStream);
        }
        this.outputStream.flush();
        this.outputStream.close();
    }

    private Workbook getWorkBook() throws IOException {
        if (this.type == ExcelType.XLS) {
            return new HSSFWorkbook();
        }
        return new XSSFWorkbook();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }
}

