/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.gson.internal.LinkedTreeMap;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ToolJson {
    public static String toJson(Object data) throws ExceptionIO {
        return ToolJson.toJson(data, true);
    }

    public static String toJson(Object data, boolean escapeNoAscil) throws ExceptionIO {
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper();
            mapper.getFactory().configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, escapeNoAscil);
            if (Collection.class.isAssignableFrom(data.getClass())) {
                return mapper.writerWithType(new TypeReference<List<?>>(){}).writeValueAsString(data);
            }
            return mapper.writeValueAsString(data);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static <T> List<T> readJsonList(File data, Class<T> clazz) throws ExceptionIO {
        try {
            return (List)ToolJson.newObjectMapper().readValue(data, (JavaType)ToolJson.newObjectMapper().getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            TLogger.get(ToolJson.class).error((Throwable)e);
            throw new ExceptionIO(e);
        }
    }

    public static <T> List<T> readJsonList(String data, Class<T> clazz) throws ExceptionIO {
        try {
            return (List)ToolJson.newObjectMapper().readValue(data, (JavaType)ToolJson.newObjectMapper().getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (UnrecognizedPropertyException e) {
            TLogger.get(ToolJson.class).error((Throwable)e);
            throw new ExceptionIO((IOException)((Object)e), new Object[]{e.getMessage(), e.getPropertyName()});
        }
        catch (IOException e) {
            TLogger.get(ToolJson.class).error((Throwable)e);
            throw new ExceptionIO(e);
        }
    }

    public static String toJsonOneObject(Object data) throws ExceptionIO {
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            mapper.writeValue((OutputStream)out, data);
            return new String(out.toByteArray());
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static String toJson(Object data, TypeReference<?> type) throws ExceptionIO {
        return ToolJson.toJson(data, type, new HashMap());
    }

    public static String toJsonList(Object data, final Class type) throws ExceptionIO {
        return ToolJson.toJson(data, new TypeReference(){

            public Type getType() {
                return type;
            }
        }, new HashMap());
    }

    public static String toJson(Object data, TypeReference<?> type, Map<? extends ConfigFeature, Boolean> props) throws ExceptionIO {
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper(props);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            mapper.writerWithType(type).writeValue((OutputStream)out, data);
            return new String(out.toByteArray());
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static <T> T readJson(String result, Class<T> toRet) throws ExceptionIO {
        if (result == null) {
            return null;
        }
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper();
            return (T)mapper.readValue(result, toRet);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public static <T> T readJson(File result, Class<T> toRet, Map.Entry<? extends ConfigFeature, Boolean> ... props) throws ExceptionIO {
        HashMap<ConfigFeature, Boolean> properties = new HashMap<ConfigFeature, Boolean>();
        for (Map.Entry<? extends ConfigFeature, Boolean> prop : props) {
            ConfigFeature conf = prop.getKey();
            properties.put(conf, prop.getValue());
        }
        return ToolJson.readJson(result, toRet, properties);
    }

    public static <T> T readJson(File result, Class<T> toRet) throws ExceptionIO {
        return ToolJson.readJson(result, toRet, new HashMap());
    }

    public static <T> T readJson(File result, Class<T> toRet, Map<? extends ConfigFeature, Boolean> props) throws ExceptionIO {
        if (result == null) {
            return null;
        }
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper(props);
            return (T)mapper.readValue(result, toRet);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static <T> T readJson(String result, Class<T> toRet, Map.Entry<? extends ConfigFeature, Boolean> ... props) throws ExceptionIO {
        HashMap<ConfigFeature, Boolean> properties = new HashMap<ConfigFeature, Boolean>();
        for (Map.Entry<? extends ConfigFeature, Boolean> prop : props) {
            ConfigFeature conf = prop.getKey();
            properties.put(conf, prop.getValue());
        }
        return ToolJson.readJson(result, toRet, properties);
    }

    public static <T> T readJson(String result, Class<T> toRet, Map<? extends ConfigFeature, Boolean> props) throws ExceptionIO {
        if (result == null) {
            return null;
        }
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper(props);
            return (T)mapper.readValue(result, toRet);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static Map.Entry<? extends ConfigFeature, Boolean> propIgnoreUndefined() {
        return new AbstractMap.SimpleEntry<DeserializationFeature, Boolean>(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static <T> T readJson(String jsonString, TypeReference<T> type) throws ExceptionIO {
        if (jsonString == null) {
            return null;
        }
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper();
            return (T)mapper.readValue(jsonString, type);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static <T> T readJson(String jsonString, TypeReference<T> type, Map<? extends ConfigFeature, Boolean> props) throws ExceptionIO {
        if (jsonString == null) {
            return null;
        }
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper(props);
            return (T)mapper.readValue(jsonString, type);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static Object readJson(String jsonString, JavaType type) throws ExceptionIO {
        if (jsonString == null) {
            return null;
        }
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper();
            return mapper.readValue(jsonString, type);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    private static ObjectMapper newObjectMapper() {
        return ToolJson.newObjectMapper(new HashMap());
    }

    private static ObjectMapper newObjectMapper(Map<? extends ConfigFeature, Boolean> props) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        Set<? extends ConfigFeature> keys = props.keySet();
        for (ConfigFeature configFeature : keys) {
            if (DeserializationFeature.class.isAssignableFrom(configFeature.getClass())) {
                mapper.configure((DeserializationFeature)configFeature, props.get(configFeature).booleanValue());
            }
            if (MapperFeature.class.isAssignableFrom(configFeature.getClass())) {
                mapper.configure((MapperFeature)configFeature, props.get(configFeature).booleanValue());
            }
            if (!SerializationFeature.class.isAssignableFrom(configFeature.getClass())) continue;
            mapper.configure((MapperFeature)configFeature, props.get(configFeature).booleanValue());
        }
        return mapper;
    }

    public static Map<String, Object> readJsonAsMap(String fileContent) throws ExceptionIO {
        return ToolJson.readJsonAsMap(fileContent, new HashMap());
    }

    public static Map<String, Object> readJsonAsMap(String fileContent, Map<? extends ConfigFeature, Boolean> props) throws ExceptionIO {
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper(props);
            TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
            HashMap o = (HashMap)mapper.readValue(fileContent, (TypeReference)typeRef);
            return o;
        }
        catch (JsonProcessingException ex) {
            throw new ExceptionIO((IOException)((Object)ex));
        }
    }

    public static LinkedTreeMap<String, Object> readJsonAsLinkedMap(String fileContent) throws ExceptionIO {
        return ToolJson.readJsonAsLinkedMap(fileContent, new HashMap());
    }

    public static LinkedTreeMap<String, Object> readJsonAsLinkedMap(String fileContent, Map<? extends ConfigFeature, Boolean> props) throws ExceptionIO {
        try {
            ObjectMapper mapper = ToolJson.newObjectMapper(props);
            TypeReference<LinkedTreeMap<String, Object>> typeRef = new TypeReference<LinkedTreeMap<String, Object>>(){};
            LinkedTreeMap o = (LinkedTreeMap)mapper.readValue(fileContent, (TypeReference)typeRef);
            return o;
        }
        catch (JsonProcessingException ex) {
            throw new ExceptionIO((IOException)((Object)ex));
        }
    }

    public static List<HashMap> readJsonAsMapList(String data) throws ExceptionIO {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode json = mapper.readTree(data);
            if (!json.isArray()) {
                TypeReference<HashMap> typeRef = new TypeReference<HashMap>(){};
                Map m = (Map)mapper.readValue(data, (TypeReference)typeRef);
                LinkedList<HashMap> ret = new LinkedList<HashMap>();
                ret.add((HashMap)m);
                return ret;
            }
            TypeReference<List<HashMap>> typeRef = new TypeReference<List<HashMap>>(){};
            List o = (List)mapper.readValue(data, (TypeReference)typeRef);
            return o;
        }
        catch (JsonProcessingException ex) {
            throw new ExceptionIO((IOException)((Object)ex));
        }
    }

    public static List<LinkedTreeMap> readJsonAsLinkedMapList(String data) throws ExceptionIO {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode json = mapper.readTree(data);
            if (!json.isArray()) {
                TypeReference<LinkedTreeMap> typeRef = new TypeReference<LinkedTreeMap>(){};
                Map m = (Map)mapper.readValue(data, (TypeReference)typeRef);
                LinkedList<LinkedTreeMap> ret = new LinkedList<LinkedTreeMap>();
                ret.add((LinkedTreeMap)m);
                return ret;
            }
            TypeReference<List<LinkedTreeMap>> typeRef = new TypeReference<List<LinkedTreeMap>>(){};
            List o = (List)mapper.readValue(data, (TypeReference)typeRef);
            return o;
        }
        catch (JsonProcessingException ex) {
            throw new ExceptionIO((IOException)((Object)ex));
        }
    }

    public static void toJson(Object data, File fileData) throws ExceptionIO {
        String json = ToolJson.toJson(data);
        ToolFile.writeStringInFile(fileData, json);
    }
}

