/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.logcronoanalise;

import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.string.TString;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class ToolLogCronoAnalise {
    private static Date lastDate;
    private static List<ItemLog> data;
    private static ItemLog last;

    public static void start() {
        if (lastDate == null) {
            lastDate = new Date();
            data = new LinkedList<ItemLog>();
        }
    }

    public static void endAndPrintAll() {
        ToolLogCronoAnalise.endItemLog(last);
        ToolLogCronoAnalise.printAll();
        ToolLogCronoAnalise.end();
    }

    public static void end() {
        ToolLogCronoAnalise.endItemLog(last);
        last = null;
        lastDate = null;
        data = new LinkedList<ItemLog>();
    }

    public static void addTask(String descricao) {
        ToolLogCronoAnalise.start();
        ToolLogCronoAnalise.endItemLog(last);
        last = ToolLogCronoAnalise.newItemLog(descricao);
    }

    public static void printAll() {
        System.out.println("--------------------------------------------------");
        System.out.println("Dados analise:\n");
        for (ItemLog il : data) {
            System.out.println("Tempo: " + TString.completaZeros(String.valueOf(il.getMilisegundos()), 3) + " Tarefa: " + il.descricao + "\n");
        }
        System.out.println("--------------------------------------------------");
    }

    private static ItemLog newItemLog(String descricao) {
        ItemLog item = new ItemLog();
        item.setDataInicio(new Date());
        item.setDescricao(descricao);
        data.add(item);
        return item;
    }

    private static void endItemLog(ItemLog last) {
        if (last == null) {
            return;
        }
        last.setDataFim(new Date());
        last.setMilisegundos(TDate.difBetweenDatesInMiliseconds(last.getDataInicio(), last.getDataFim()));
    }

    public static String printAllStr() {
        StringBuilder sb = new StringBuilder();
        sb.append("--------------------------------------------------");
        sb.append("Dados analise:\n");
        for (ItemLog il : data) {
            sb.append("Tempo: ").append(TString.completaZeros(String.valueOf(il.getMilisegundos()), 3)).append(" Tarefa: ").append(il.descricao).append("\n");
        }
        sb.append("--------------------------------------------------");
        return sb.toString();
    }

    static {
        data = new LinkedList<ItemLog>();
    }

    public static class ItemLog {
        private Date dataInicio;
        private Date dataFim;
        private Long milisegundos;
        private String descricao;

        public Date getDataInicio() {
            return this.dataInicio;
        }

        public void setDataInicio(Date dataInicio) {
            this.dataInicio = dataInicio;
        }

        public Date getDataFim() {
            return this.dataFim;
        }

        public void setDataFim(Date dataFim) {
            this.dataFim = dataFim;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public void setDescricao(String descricao) {
            this.descricao = descricao;
        }

        public Long getMilisegundos() {
            return this.milisegundos;
        }

        public void setMilisegundos(Long milisegundos) {
            this.milisegundos = milisegundos;
        }
    }
}

