/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.system;

import com.kstruct.gethostname4j.Hostname;
import com.touchcomp.basementorexceptions.exceptions.impl.hardware.ExceptionHardware;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.system.StreamGobbler;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class ToolSystem {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 49151;

    public static String getSystemName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindows() {
        return ToolSystem.getSystemName().contains("win");
    }

    public static boolean isMac() {
        return ToolSystem.getSystemName().contains("mac");
    }

    public static boolean isUnix() {
        return ToolSystem.getSystemName().contains("nix") || ToolSystem.getSystemName().contains("nux") || ToolSystem.getSystemName().indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return ToolSystem.getSystemName().contains("sunos");
    }

    public static PrintService getPrinter(String name) {
        PrintService[] printServices;
        for (PrintService p : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public static PrintService getDefaultPrinter() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public static PrintService[] getPrinters(String name) {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        return printServices;
    }

    public static void copyToClipboard(String finish) {
        StringSelection stringSelection = new StringSelection(finish);
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    public static String getFromClipboard() throws ExceptionHardware {
        try {
            String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            return data;
        }
        catch (Exception ex) {
            TLogger.get(ToolSystem.class).error((Throwable)ex);
            throw new ExceptionHardware("E.HAR.000002", new Object[]{ex.getMessage()});
        }
    }

    public static String[] getAllMacAddress() throws ExceptionHardware {
        try {
            LinkedList<String> macs = new LinkedList<String>();
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null) continue;
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X-", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                macs.add(res1.toString());
            }
            if (macs.isEmpty()) {
                macs.add("02:00:00:00:00:00");
            }
            return macs.toArray(new String[0]);
        }
        catch (Exception ex) {
            TLogger.get(ToolSystem.class).error((Throwable)ex);
            throw new ExceptionHardware("E.HAR.000001", new Object[]{ex.getMessage()});
        }
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static String getHostName() {
        return Hostname.getHostname();
    }

    public static String getHostAddress() throws UnknownHostException {
        InetAddress ip = InetAddress.getLocalHost();
        return ip != null ? ip.getHostAddress() : null;
    }

    public static String getUserName() throws UnknownHostException {
        return System.getProperty("user.name");
    }

    public static String getIpPublico() throws ExceptionIO {
        try {
            String newLine;
            URL url = new URL("https://api.ipify.org?format=json");
            HttpsURLConnection conexao = (HttpsURLConnection)url.openConnection();
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conexao.getInputStream()));
            String nextLine = "";
            while ((newLine = reader.readLine()) != null) {
                sb.append(nextLine).append(newLine);
            }
            return sb.toString();
        }
        catch (IOException e) {
            TLogger.get(ToolSystem.class).error((Throwable)e);
            throw new ExceptionIO(e);
        }
    }

    public static String getEnvValue(String key) {
        return System.getenv(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortIsInUse(Integer port) {
        if (port < 1100 || port > 49151) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static String execCommandTerminal(String command) throws ExceptionInvalidState {
        String str = ToolSystem.execCommandTerminal(null, command);
        return str;
    }

    public static String execCommandTerminal(File execDir, String ... command) throws ExceptionInvalidState {
        try {
            String[] commands = new String[command.length + 2];
            if (!ToolSystem.isWindows()) {
                commands[0] = "/bin/bash";
                commands[1] = "-c";
            } else {
                commands[0] = "/powershell.exe";
                commands[1] = "/c";
            }
            System.arraycopy(command, 0, commands, 2, command.length);
            ProcessBuilder builder = new ProcessBuilder(commands);
            if (execDir != null) {
                builder.directory(execDir);
            }
            Process process = builder.start();
            StreamGobbler stream = new StreamGobbler(process.getErrorStream(), System.out::println);
            Executors.newSingleThreadExecutor().submit(stream);
            int exitCode = process.waitFor();
            int count = 0;
            do {
                Thread.sleep(100L);
            } while (stream.isIsRunning() && stream.isIsRunning() && ++count < 500);
            if (exitCode != 0) {
                throw new ExceptionInvalidState("E.GEN.000054", new Object[]{command, stream.getBuffer().toString()});
            }
            return stream.getBuffer().toString();
        }
        catch (InterruptedException ex) {
            TLogger.get(ToolSystem.class).error((Throwable)ex);
            throw new ExceptionInvalidState("E.GEN.000054", new Object[]{command, ex.getMessage()});
        }
        catch (IOException ex) {
            TLogger.get(ToolSystem.class).error((Throwable)ex);
            throw new ExceptionInvalidState("E.GEN.000054", new Object[]{command, ex.getMessage()});
        }
    }
}

