/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.webserviceclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.EnumExcepWebService;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementortools.model.net.ProxyNet;
import com.touchcomp.basementortools.tools.certificado.ToolCertificadoSocketUtil;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.web.ToolWebResponse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public abstract class ToolRESTWebServiceClient {
    public static <K> K createServiceGet(String servidor, String webServicePath, Class<K> returnType) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.readJson(ToolRESTWebServiceClient.createServiceGet(servidor, webServicePath, (ProxyNet)null), returnType);
    }

    public static <K> K createServiceGet(String servidor, String webServicePath, TypeReference<K> typeReference) throws ExceptionWebService, ExceptionIO {
        String data = ToolRESTWebServiceClient.createServiceGet(servidor, webServicePath, (ProxyNet)null);
        return ToolRESTWebServiceClient.readJson(data, typeReference);
    }

    public static <K> K createServiceGet(String servidor, String webServicePath, Class<K> returnType, ProxyNet proxy) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.readJson(ToolRESTWebServiceClient.createServiceGet(servidor, webServicePath, proxy), returnType);
    }

    public static String createServiceGet(String servidor, String webServicePath, ProxyNet proxy) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.createServiceGet(servidor, webServicePath, proxy, 0);
    }

    public static String createServiceGet(String servidor, String webServicePath, ProxyNet proxy, int timeout) throws ExceptionWebService, ExceptionIO {
        String path = servidor + webServicePath;
        return ToolRESTWebServiceClient.createServiceGet(path, proxy, timeout);
    }

    public static String createServiceGet(String path, ProxyNet proxy) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.createServiceGet(path, proxy, 0);
    }

    public static String createServiceGet(String path, ProxyNet proxy, int timeout) throws ExceptionWebService, ExceptionIO {
        try {
            String output;
            HttpURLConnection conn = ToolRESTWebServiceClient.initConnection(path, proxy);
            if (conn.getResponseCode() != 200) {
                ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse(conn.getResponseCode());
                throw new ExceptionWebService(stat.getStatusCode(), EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + stat.getMesssage() + " \n Mensagem Servidor: " + conn.getResponseMessage() + " \n URL: " + path});
            }
            if (timeout > 0) {
                conn.setReadTimeout(timeout);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Object resp = "";
            while ((output = br.readLine()) != null) {
                resp = (String)resp + output;
            }
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException e) {
            throw new ExceptionWebService((IOException)e, new Object[]{e.getMessage(), path});
        }
        catch (IOException e) {
            throw new ExceptionWebService(e, new Object[]{e.getMessage(), path});
        }
    }

    public static String createServiceGetSSL(String servidor, String webServicePath, ProxyNet proxy, File keyStore, String password, TimeUnit unit, int timeout) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        String path = servidor + webServicePath;
        return ToolRESTWebServiceClient.createServiceGetSSL(path, proxy, keyStore, password, unit, timeout);
    }

    public static String createServiceGetSSL(String servidor, String webServicePath, ProxyNet proxy, File keyStore, String password) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        String path = servidor + webServicePath;
        return ToolRESTWebServiceClient.createServiceGetSSL(path, proxy, keyStore, password, null, 0);
    }

    public static String createServiceGetSSL(String servidor, String webServicePath, ProxyNet proxy, TimeUnit unit, int timeout) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        String path = servidor + webServicePath;
        return ToolRESTWebServiceClient.createServiceGetSSL(path, proxy, null, null, unit, timeout);
    }

    public static String createServiceGetSSL(String servidor, String webServicePath, ProxyNet proxy) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        String path = servidor + webServicePath;
        return ToolRESTWebServiceClient.createServiceGetSSL(path, proxy, null, null, null, 0);
    }

    public static String createServiceGetSSL(String path, ProxyNet proxy) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        return ToolRESTWebServiceClient.createServiceGetSSL(path, proxy, null, null, null, 0);
    }

    public static String createServiceGetSSL(String path, ProxyNet proxy, File keyStore, String password, TimeUnit unit, int timeout) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        try {
            String output;
            HttpsURLConnection conn = (HttpsURLConnection)new URL(path).openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
            if (keyStore != null) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                Certificate theCertificate = ToolRESTWebServiceClient.getCertificateFromFile(keyStore);
                KeyStore keyStor = ToolRESTWebServiceClient.getKeyStore(theCertificate, password);
                TrustManagerFactory tmFactory = ToolRESTWebServiceClient.getTrustManagerFactory(keyStor, "PKIX");
                sslContext.init(null, tmFactory.getTrustManagers(), null);
                conn.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            if (conn.getResponseCode() != 200) {
                ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse(conn.getResponseCode());
                throw new ExceptionWebService(EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + stat.getMesssage() + " \n Mensagem Servidor: " + conn.getResponseMessage() + " \n URL: " + path});
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Object resp = "";
            System.out.println("Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                resp = (String)resp + output;
            }
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new ExceptionWebService((IOException)e, new Object[]{e.getMessage(), path});
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionWebService(e, new Object[]{e.getMessage(), path});
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
            throw new ExceptionWebService(e, new Object[]{e.getMessage(), path});
        }
    }

    public static <K> K createServicePost(String servidor, String webServicePath, String input, Class<K> returnType) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.readJson(ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, input), returnType);
    }

    public static <K> K createServicePost(String servidor, String webServicePath, String input, TypeReference<K> returnType) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.readJson(ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, input), returnType);
    }

    public static <K> K createServicePost(String servidor, String webServicePath, Object input, TypeReference<K> returnType) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.readJson(ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, input), returnType);
    }

    public static <K> K createServicePost(String servidor, String webServicePath, Object input, Class<K> returnType) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, ToolJson.toJson(input), returnType);
    }

    private static HttpURLConnection initConnection(String uri, ProxyNet proxy) throws MalformedURLException, ProtocolException, IOException {
        return ToolRESTWebServiceClient.initConnection(uri, proxy, null, -1L);
    }

    private static HttpURLConnection initConnection(String uri, final ProxyNet proxy, TimeUnit unit, long timeout) throws MalformedURLException, ProtocolException, IOException {
        URL url = new URL(uri);
        HttpURLConnection conn = null;
        if (proxy != null) {
            Proxy temp = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxy.getIp(), proxy.getPorta()));
            conn = (HttpURLConnection)url.openConnection(temp);
            if (proxy.isPossuiAutenticacao()) {
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxy.getUsuario(), proxy.getSenha().toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        if (timeout > 0L && unit != null) {
            conn.setConnectTimeout((int)unit.toMillis(timeout));
            conn.setReadTimeout(conn.getConnectTimeout());
        }
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
        return conn;
    }

    public static String createServicePost(String servidor, String webServicePath, String input) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, input, (ProxyNet)null);
    }

    public static String createServicePost(String servidor, String webServicePath, String input, ProxyNet proxy) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, input, proxy, true);
    }

    public static <K> K createServicePost2(String servidor, String webServicePath, Object input, ProxyNet proxy, Class<K> returnType) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.readJson(ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, ToolJson.toJson(input), proxy, true), returnType);
    }

    public static String createServicePost(String servidor, String webServicePath, String input, ProxyNet proxy, boolean encode) throws ExceptionWebService, ExceptionIO {
        String path = (String)servidor + webServicePath;
        HttpURLConnection conn = null;
        try {
            String output;
            if (!((String)servidor).endsWith("/")) {
                servidor = (String)servidor + "/";
            }
            if (webServicePath.startsWith("/")) {
                webServicePath = webServicePath.substring(1);
            }
            conn = ToolRESTWebServiceClient.initConnection(path, proxy);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", Integer.toString(input.length()));
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
            OutputStream os = conn.getOutputStream();
            if (encode) {
                os.write(ToolHexString.encodeToHex(input).getBytes());
            } else {
                os.write(input.getBytes());
            }
            os.flush();
            if (conn.getResponseCode() != 200) {
                String output2;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                Object resp = "";
                while ((output2 = br.readLine()) != null) {
                    resp = (String)resp + output2;
                }
                ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse(conn.getResponseCode());
                throw new ExceptionWebService(EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + stat.getMesssage() + " \n Mensagem Servidor: " + (String)resp + " \n URL: " + path});
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Object resp = "";
            while ((output = br.readLine()) != null) {
                resp = (String)resp + output;
            }
            conn.disconnect();
            String string = resp;
            return string;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new ExceptionWebService((IOException)e, new Object[]{e.getMessage(), path});
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionWebService(e, new Object[]{e.getMessage(), path});
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static <K> K createServicePostSSL(String servidor, String webServicePath, Object input, Class<K> returnType, ProxyNet proxy, File keyStore, String password) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        return ToolRESTWebServiceClient.readJson(ToolRESTWebServiceClient.createServicePostSSL(servidor, webServicePath, ToolJson.toJson(input), proxy, keyStore, password), returnType);
    }

    public static String createServicePostSSL(String servidor, String webServicePath, String input, ProxyNet proxy, File keyStore, String password) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        String path = (String)servidor + webServicePath;
        try {
            String output;
            if (!((String)servidor).endsWith("/")) {
                servidor = (String)servidor + "/";
            }
            if (webServicePath.startsWith("/")) {
                webServicePath = webServicePath.substring(1);
            }
            HttpsURLConnection conn = (HttpsURLConnection)new URL(path).openConnection();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            Certificate theCertificate = ToolRESTWebServiceClient.getCertificateFromFile(keyStore);
            KeyStore keyStor = ToolRESTWebServiceClient.getKeyStore(theCertificate, password);
            TrustManagerFactory tmFactory = ToolRESTWebServiceClient.getTrustManagerFactory(keyStor, "PKIX");
            sslContext.init(null, tmFactory.getTrustManagers(), null);
            conn.setSSLSocketFactory(sslContext.getSocketFactory());
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
            OutputStream os = conn.getOutputStream();
            os.write(ToolHexString.encodeToHex(input).getBytes());
            os.flush();
            if (conn.getResponseCode() != 200) {
                ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse(conn.getResponseCode());
                throw new ExceptionWebService(EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + stat.getMesssage() + " \n Mensagem Servidor: " + conn.getResponseMessage() + " \n URL: " + path});
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Object resp = "";
            System.out.println("Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                resp = (String)resp + output;
            }
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new ExceptionWebService((IOException)e, new Object[]{e.getMessage(), path});
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionWebService(e, new Object[]{e.getMessage(), path});
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static String createServicePostSSL(String url, String input, ProxyNet proxy, InputStream privateCert, String pass) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        try {
            String output;
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("content-type", "application/xml");
            conn.setSSLSocketFactory(new ToolCertificadoSocketUtil().createSSLContext(privateCert, pass).getSocketFactory());
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(input.getBytes());
            os.flush();
            if (conn.getResponseCode() != 200 && conn.getResponseCode() != 201) {
                ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse(conn.getResponseCode());
                throw new ExceptionWebService(EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + stat.getMesssage() + " \n Mensagem Servidor: " + conn.getResponseMessage() + " \n URL: " + url + " \n Detalhes: " + (conn.getErrorStream() != null ? ToolFile.getConteudoArquivo(conn.getErrorStream()) : "ND")});
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Object resp = "";
            System.out.println("Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                resp = (String)resp + output;
            }
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new ExceptionWebService((IOException)e, new Object[]{e.getMessage(), url});
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionWebService(e, new Object[]{e.getMessage(), url});
        }
    }

    public static String createServiceGetSSL(String url, ProxyNet proxy, InputStream privateCert, String pass) throws ExceptionWebService, ExceptionIO, ExceptionCertificado {
        try {
            String output;
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            conn.setRequestProperty("content-type", "application/xml");
            conn.setSSLSocketFactory(new ToolCertificadoSocketUtil().createSSLContext(privateCert, pass).getSocketFactory());
            if (conn.getResponseCode() != 200 && conn.getResponseCode() != 201) {
                ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse(conn.getResponseCode());
                throw new ExceptionWebService(EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + stat.getMesssage() + " \n Mensagem Servidor: " + conn.getResponseMessage() + " \n URL: " + url + " \n Detalhes: " + (conn.getErrorStream() != null ? ToolFile.getConteudoArquivo(conn.getErrorStream()) : "ND")});
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Object resp = "";
            System.out.println("Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                resp = (String)resp + output;
            }
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new ExceptionWebService((IOException)e, new Object[]{e.getMessage(), url});
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionWebService(e, new Object[]{e.getMessage(), url});
        }
    }

    public static String createServicePost(String servidor, String webServicePath, Object input) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, ToolJson.toJson(input));
    }

    public static String createServicePost(String servidor, String webServicePath, Object input, ProxyNet proxy) throws ExceptionWebService, ExceptionIO {
        return ToolRESTWebServiceClient.createServicePost(servidor, webServicePath, ToolJson.toJson(input), proxy);
    }

    public static <K> K createServicePut(String servidorConexao, String webServicePath, Object input, TypeReference<K> returnType) throws ExceptionIO, ExceptionWebService {
        return ToolRESTWebServiceClient.readJson(ToolRESTWebServiceClient.createServicePut(servidorConexao, webServicePath, ToolJson.toJson(input), null, false), returnType);
    }

    public static String createServicePut(String servidor, String webServicePath, String input, ProxyNet proxy, boolean encodeHex) throws ExceptionWebService, ExceptionIO {
        String path = (String)servidor + webServicePath;
        try {
            String output;
            if (!((String)servidor).endsWith("/")) {
                servidor = (String)servidor + "/";
            }
            if (webServicePath.startsWith("/")) {
                webServicePath = webServicePath.substring(1);
            }
            HttpURLConnection conn = ToolRESTWebServiceClient.initConnection(path, proxy);
            conn.setDoOutput(true);
            conn.setRequestMethod("PUT");
            conn.setRequestProperty("Content-Length", Integer.toString(input.length()));
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
            OutputStream os = conn.getOutputStream();
            if (encodeHex) {
                os.write(ToolHexString.encodeToHex(input).getBytes());
            } else {
                os.write(input.getBytes());
            }
            os.flush();
            if (conn.getResponseCode() != 200) {
                ToolWebResponse.ResponseStat stat = ToolWebResponse.checkResponse(conn.getResponseCode());
                throw new ExceptionWebService(EnumExcepWebService.ERRO_CHAMAR_WEBSERVICE, new Object[]{conn.getResponseCode() + ": " + stat.getMesssage() + " \n Mensagem Servidor: " + conn.getResponseMessage() + " \n URL: " + path});
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            Object resp = "";
            System.out.println("Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                resp = (String)resp + output;
            }
            conn.disconnect();
            return resp;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new ExceptionWebService((IOException)e, new Object[]{e.getMessage(), path});
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionWebService(e, new Object[]{e.getMessage(), path});
        }
    }

    private static <K> K readJson(String data, Class<K> returnType) throws ExceptionIO {
        Map m = ToolMethods.toMap(ToolMethods.pair(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false));
        return ToolJson.readJson(data, returnType, m);
    }

    private static <K> K readJson(String data, TypeReference<K> typeReference) throws ExceptionIO {
        Map m = ToolMethods.toMap(ToolMethods.pair(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false));
        return ToolJson.readJson(data, typeReference, m);
    }

    public static TrustManagerFactory getTrustManagerFactory(KeyStore keyStore, String tmAlgorithm) throws NoSuchAlgorithmException, KeyStoreException {
        if (tmAlgorithm == null) {
            tmAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(tmAlgorithm);
        tmFactory.init(keyStore);
        return tmFactory;
    }

    public static KeyStore getKeyStore(Certificate theCert, String password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, password.toCharArray());
        keyStore.setCertificateEntry("theCert", theCert);
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCertificateFromFile(File certFile) throws CertificateException, IOException {
        Certificate theCert;
        if (certFile == null || certFile.length() == 0L) {
            throw new CertificateException("ERROR: Null or zero length certificate file names are not allowed.");
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        BufferedInputStream certStream = new BufferedInputStream(new FileInputStream(certFile));
        try {
            theCert = certFactory.generateCertificate(certStream);
        }
        finally {
            if (certStream != certStream) {
                ((InputStream)certStream).close();
            }
        }
        return theCert;
    }
}

