/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.zip;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ToolZipUtils {
    public static byte[] compress(byte[] str) throws ExceptionZip {
        return ToolZipUtils.compress(String.valueOf(str));
    }

    public static byte[] compressStr(String str) throws ExceptionZip {
        return ToolZipUtils.compress(str);
    }

    public static byte[] compress(String str) throws ExceptionZip {
        DeflaterOutputStream gzip = null;
        try {
            if (str == null || str.length() == 0) {
                byte[] byArray = null;
                return byArray;
            }
            System.out.println("String length : " + str.length());
            ByteArrayOutputStream obj = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(obj);
            gzip.write(str.getBytes());
            gzip.close();
            byte[] byArray = obj.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new ExceptionZip(ex);
        }
        finally {
            try {
                if (gzip != null) {
                    gzip.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ToolZipUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static String decompress(byte[] str) throws ExceptionZip, XMLStreamException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(str);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = factory.createXMLStreamReader(inputStream);
        System.out.println(xmlReader.getEncoding());
        String enconding = xmlReader.getEncoding();
        return ToolZipUtils.decompress(str, ToolMethods.isStrWithData(enconding) ? enconding : "UTF-8");
    }

    private static String decompress(byte[] str, String charset) throws ExceptionZip {
        GZIPInputStream gis = null;
        try {
            int len;
            gis = new GZIPInputStream(new ByteArrayInputStream(str));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((len = gis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            String string = new String(baos.toByteArray(), charset);
            return string;
        }
        catch (IOException ex) {
            throw new ExceptionZip(ex);
        }
        finally {
            try {
                if (gis != null) {
                    gis.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ToolZipUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static File compress(List<File> ret) throws ExceptionIO {
        File out = ToolFile.createTempFile("arquivo_zip", ".zip");
        ToolZipUtils.compress(out, ret);
        return out;
    }

    public static File compress(String fileZipName, List<File> ret) throws ExceptionIO {
        File out = new File(ToolFile.getTMPDir() + File.separator + fileZipName);
        ToolZipUtils.compress(out, ret);
        return out;
    }

    public static File compress(File zip, List<File> files) throws ExceptionIO {
        ToolZipUtils.compress(zip, files.toArray(new File[0]));
        return zip;
    }

    public static File compressFilesFolder(File sourceDirPath, File zipFilePath) throws ExceptionIO {
        return ToolZipUtils.compressFilesFolder(sourceDirPath.getAbsolutePath(), zipFilePath.getAbsolutePath());
    }

    public static File compressFilesFolder(String sourceDirPath, String zipFilePath) throws ExceptionIO {
        try {
            File f = new File(zipFilePath);
            try (ZipOutputStream zs = new ZipOutputStream(new FileOutputStream(f));){
                Path pp = Paths.get(sourceDirPath, new String[0]);
                Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                    try {
                        zs.putNextEntry(zipEntry);
                        Files.copy(path, zs);
                        zs.closeEntry();
                    }
                    catch (IOException e) {
                        System.err.println(e);
                    }
                });
            }
            return f;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static File compress(File zip, File[] files) throws ExceptionIO {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(zip);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            for (File fileToZip : files) {
                ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                zipOut.putNextEntry(zipEntry);
                if (!fileToZip.isDirectory()) {
                    int length;
                    FileInputStream fis = new FileInputStream(fileToZip);
                    byte[] bytes = new byte[1024];
                    while ((length = fis.read(bytes)) >= 0) {
                        zipOut.write(bytes, 0, length);
                    }
                    fis.close();
                }
                zipOut.closeEntry();
            }
            zipOut.close();
            fos.close();
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ToolZipUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return zip;
    }

    public static void listEntries(File arquivoZip) throws ExceptionIO {
        try {
            ZipFile zipFile = new ZipFile(arquivoZip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                System.out.println(entry.getName());
            }
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{arquivoZip.getAbsoluteFile()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File arquivoZip, File destFolder) throws ExceptionIO {
        ZipFile zip = null;
        File arquivo = null;
        InputStream is = null;
        OutputStream os = null;
        int TAMANHO_BUFFER = 2048;
        byte[] buffer = new byte[TAMANHO_BUFFER];
        if (!destFolder.exists() || !destFolder.isDirectory()) {
            return;
        }
        try {
            if (!destFolder.exists()) {
                destFolder.mkdirs();
            }
            zip = new ZipFile(arquivoZip);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entrada = e.nextElement();
                String name = ToolZipUtils.invertBarras(entrada.getName());
                arquivo = new File(destFolder.getAbsolutePath() + File.separator + name);
                System.out.println("extraindo " + String.valueOf(arquivo));
                if (entrada.isDirectory()) {
                    if (arquivo.exists()) continue;
                    arquivo.mkdirs();
                    continue;
                }
                if (!arquivo.getParentFile().exists()) {
                    arquivo.getParentFile().mkdirs();
                }
                try {
                    is = zip.getInputStream(entrada);
                    os = new FileOutputStream(arquivo);
                    int bytesLidos = 0;
                    if (is == null) {
                        throw new ZipException("Erro ao ler a entrada do zip: " + name);
                    }
                    while ((bytesLidos = is.read(buffer)) > 0) {
                        os.write(buffer, 0, bytesLidos);
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) continue;
                    os.close();
                }
            }
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static String invertBarras(String name) {
        name = name.replace("\\", "/");
        return name;
    }
}

