/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import contatocore.util.UtilAbstractObjectBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;

public class UtilAbstractCachedFind {
    private static HashMap cache;

    public static List simpleFindByCriterialsOnCache(String className, Session session, List keys) throws ClassNotFoundException {
        Object dataObject = UtilAbstractCachedFind.getCache().get(className);
        ArrayList result = new ArrayList();
        if (dataObject != null) {
            List data = (List)dataObject;
            for (Object entity : data) {
                if (!UtilAbstractCachedFind.matchObject(entity, keys).booleanValue()) continue;
                result.add(entity);
            }
        }
        if (result.isEmpty()) {
            return UtilAbstractCachedFind.simpleFindByCriterials(className, session, keys);
        }
        return result;
    }

    public static List simpleFindByCriterialsOnCache(String className, Session session, List<Criterion> keys, Integer start) throws ClassNotFoundException {
        Object dataObject = UtilAbstractCachedFind.getCache().get(className);
        ArrayList result = new ArrayList();
        if (dataObject != null) {
            List data = (List)dataObject;
            for (Object entity : data) {
                if (!UtilAbstractCachedFind.matchObject(entity, keys).booleanValue()) continue;
                result.add(entity);
            }
        }
        if (result.isEmpty()) {
            return UtilAbstractCachedFind.simpleFindByCriterials(className, session, keys, start);
        }
        return result;
    }

    public static List simpleFindByCriterialsOnCache(String className, List<Criterion> keys) throws ClassNotFoundException {
        Object dataObject = UtilAbstractCachedFind.getCache().get(className);
        ArrayList result = new ArrayList();
        if (dataObject != null) {
            List data = (List)dataObject;
            for (Object entity : data) {
                Boolean ret = UtilAbstractCachedFind.matchObject(entity, keys);
                if (!ret.equals(true)) continue;
                result.add(entity);
            }
        }
        return result;
    }

    public static void addToCache(String className, List data) {
        UtilAbstractCachedFind.getCache().put(className, data);
    }

    public static void removeFromCache(String className) {
        UtilAbstractCachedFind.getCache().remove(className);
    }

    public static void clearCache() {
        UtilAbstractCachedFind.getCache().clear();
    }

    public static Boolean isOnCache(String className) {
        return UtilAbstractCachedFind.getCache().get(className) != null;
    }

    private static List simpleFindByCriterials(String className, Session session, List<Criterion> keys) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        Criteria crit = session.createCriteria(c);
        for (Criterion Criterion2 : keys) {
            crit.add(Criterion2);
        }
        return crit.list();
    }

    private static List simpleFindByCriterials(String className, Session session, List<Criterion> keys, Integer start) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        Criteria crit = session.createCriteria(c);
        for (Criterion Criterion2 : keys) {
            crit.add(Criterion2);
        }
        crit.setFirstResult(start.intValue());
        crit.setMaxResults(50);
        return crit.list();
    }

    private static Boolean matchObject(Object entity, List<Criterion> keys) {
        Boolean isMatch = true;
        for (Criterion crit : keys) {
            try {
                String name = (String)UtilAbstractCachedFind.extractCriterionProperty("propertyName", crit);
                Object value = UtilAbstractCachedFind.extractCriterionProperty("value", crit);
                if (name == null) {
                    return false;
                }
                ArrayList<Object> holder = null;
                for (String criteria : UtilAbstractCachedFind.splitCriteria(name)) {
                    Field f;
                    if (holder == null) {
                        f = UtilAbstractObjectBuilder.searchField(criteria, entity);
                        f.setAccessible(true);
                        holder = f.get(entity);
                        continue;
                    }
                    if (holder instanceof List) {
                        ArrayList<Object> holderList = new ArrayList<Object>();
                        for (Object o : (List)holder) {
                            Field f2 = UtilAbstractObjectBuilder.searchField(criteria, o);
                            f2.setAccessible(true);
                            holderList.add(f2.get(o));
                        }
                        holder = holderList;
                        continue;
                    }
                    f = UtilAbstractObjectBuilder.searchField(criteria, holder);
                    f.setAccessible(true);
                    holder = f.get(holder);
                }
                if (holder instanceof List) {
                    if (((List)holder).contains(value)) {
                        isMatch = true;
                        continue;
                    }
                    isMatch = false;
                    continue;
                }
                if (holder == null && value == null) {
                    isMatch = true;
                    continue;
                }
                if (holder != null && ((Object)holder).equals(value)) continue;
                isMatch = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return isMatch;
    }

    private static List<String> splitCriteria(String name) {
        ArrayList<String> criterials = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.substring(i, i + 1).equals(".")) {
                criterials.add(buffer.toString());
                buffer = new StringBuilder();
                continue;
            }
            buffer.append(name.substring(i, i + 1));
        }
        criterials.add(buffer.toString());
        return criterials;
    }

    private static Object extractCriterionProperty(String property, Criterion crit) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Field propertyField = UtilAbstractObjectBuilder.searchField(property, crit);
        Object value = null;
        if (propertyField != null) {
            propertyField.setAccessible(true);
            value = propertyField.get(crit);
        }
        return value;
    }

    private static Object extractEntityValue(String fieldName, Object entity) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Field entityField = UtilAbstractObjectBuilder.searchField(fieldName, entity.getClass());
        entityField.setAccessible(true);
        Object value = entityField.get(entity);
        return value;
    }

    private static HashMap getCache() {
        if (cache == null) {
            cache = new HashMap();
        }
        return cache;
    }
}

