/*
 * Decompiled with CFR 0.152.
 */
package contatocore.util;

import contatocore.anotations.synchronization.RequiredSync;
import contatocore.anotations.synchronization.SyncUniqueKeys;
import contatocore.util.ContatoDateUtil;
import contatocore.util.UtilAbstractCachedFind;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.query.Query;

public class UtilAbstractObjectBuilder {
    public static HashMap buildHashMap(Object entity, Short includeLists, String modelPath) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>();
        Class<?> c = Class.forName(entity.getClass().getName());
        for (Field field : c.getDeclaredFields()) {
            field.setAccessible(true);
            ArrayList<HashMap> listContainer = new ArrayList<HashMap>();
            if (field.getType().equals(List.class)) {
                Method method = UtilAbstractObjectBuilder.searchMethod(UtilAbstractObjectBuilder.extractMethodName("get", field.getName()), c);
                JoinTable annotation = method.getAnnotation(JoinTable.class);
                if (includeLists == 1 || annotation != null) {
                    List list = (List)method.invoke(entity, (Object[])null);
                    if (list != null) {
                        if (includeLists == 0 && annotation != null) {
                            for (Object o : list) {
                                HashMap<String, Object> infoMap = new HashMap<String, Object>();
                                Method getIdMethod = UtilAbstractObjectBuilder.searchIdMethod(o.getClass());
                                if (getIdMethod == null) continue;
                                infoMap.put("identificador", getIdMethod.invoke(o, (Object[])null));
                                infoMap.put("class", o.getClass().getSimpleName());
                                listContainer.add(infoMap);
                            }
                        } else {
                            for (Object o : list) {
                                listContainer.add(UtilAbstractObjectBuilder.buildHashMap(o, includeLists, modelPath));
                            }
                        }
                    }
                    fieldsMap.put(field.getName(), listContainer);
                    continue;
                }
                fieldsMap.put(field.getName(), listContainer);
                continue;
            }
            if (field.get(entity) != null && field.getType().getPackage() != null && field.getType().getPackage().getName().equals(modelPath)) {
                Method getMethod = UtilAbstractObjectBuilder.searchMethod(UtilAbstractObjectBuilder.extractMethodName("get", field.getName()), c);
                Object obj = getMethod.invoke(entity, (Object[])null);
                if (UtilAbstractObjectBuilder.isRequired(field, entity).booleanValue()) {
                    fieldsMap.put(field.getName(), UtilAbstractObjectBuilder.buildHashMap(obj, includeLists, modelPath));
                    continue;
                }
                Method method = UtilAbstractObjectBuilder.searchIdMethod(field.getType());
                if (method == null) continue;
                fieldsMap.put(field.getName(), method.invoke(obj, (Object[])null));
                continue;
            }
            if (field.getName().equals("identificador")) {
                if (!UtilAbstractObjectBuilder.generateID(c).booleanValue()) continue;
                fieldsMap.put(field.getName(), field.get(entity));
                continue;
            }
            fieldsMap.put(field.getName(), field.get(entity));
        }
        returnMap.put("class", c.getSimpleName());
        returnMap.put("data", fieldsMap);
        return returnMap;
    }

    public static Object buildObject(HashMap data, String modelPath, Session session) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String classFullName = modelPath + "." + (String)data.get("class");
        HashMap pack = (HashMap)data.get("data");
        Class<?> c = Class.forName(classFullName);
        HashMap fields = UtilAbstractObjectBuilder.extractFields(c);
        Object entity = UtilAbstractObjectBuilder.createInstance(c, data, session);
        Set keys = pack.keySet();
        for (String key : keys) {
            Object value = pack.get(key);
            Field field = (Field)fields.get(key);
            if (field == null) continue;
            field.setAccessible(true);
            if (value instanceof ArrayList) {
                ArrayList<Object> list = new ArrayList<Object>();
                ArrayList objects = (ArrayList)value;
                ArrayList<Object> entityList = (ArrayList<Object>)field.get(entity);
                for (Object o : objects) {
                    HashMap<CallSite, Object> entityData;
                    HashMap arrayEntity = (HashMap)o;
                    HashMap hashMap = entityData = arrayEntity.get("data") != null ? arrayEntity.get("data") : new HashMap();
                    if (!entityData.isEmpty()) {
                        String entityName = entity.getClass().getSimpleName().substring(0, 1).toLowerCase() + entity.getClass().getSimpleName().substring(1);
                        entityData.put((CallSite)((Object)entityName), entity);
                        arrayEntity.put("listObject", UtilAbstractObjectBuilder.getListObject((List)field.get(entity), arrayEntity));
                        list.add(UtilAbstractObjectBuilder.buildObject(arrayEntity, modelPath, session));
                        continue;
                    }
                    list.add(UtilAbstractObjectBuilder.simpleFindByPrimaryKey(modelPath + "." + (String)arrayEntity.get("class"), session, arrayEntity.get("identificador")));
                }
                if (entityList != null) {
                    entityList.clear();
                    entityList.addAll(list);
                } else if (!list.isEmpty()) {
                    entityList = list;
                }
                field.set(entity, entityList);
                continue;
            }
            if (field.getType().getPackage() != null && field.getType().getPackage().getName().equals(modelPath) && value != null && !value.getClass().getPackage().getName().equals(modelPath)) {
                if (UtilAbstractObjectBuilder.isRequired(field, entity).booleanValue()) {
                    if (value instanceof HashMap) {
                        HashMap valueObject = (HashMap)value;
                        Object child = UtilAbstractObjectBuilder.buildObject(valueObject, modelPath, session);
                        Field fatherField = UtilAbstractObjectBuilder.searchField(UtilAbstractObjectBuilder.extractFieldName(entity), child.getClass());
                        if (fatherField != null) {
                            fatherField.setAccessible(true);
                            fatherField.set(child, entity);
                        }
                        field.set(entity, child);
                        continue;
                    }
                    field.set(entity, UtilAbstractObjectBuilder.simpleFindByPrimaryKey(field.getType().getName(), session, value));
                    continue;
                }
                if (value instanceof HashMap) {
                    value = ((HashMap)value).get("data");
                    value = ((HashMap)value).get("identificador");
                }
                field.set(entity, UtilAbstractObjectBuilder.simpleFindByPrimaryKey(field.getType().getName(), session, value));
                continue;
            }
            field.set(entity, value);
        }
        return entity;
    }

    public static List<String> buildSQLQueries(HashMap data, String modelPath) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<String> queries = new ArrayList<String>();
        ArrayList queriesList = new ArrayList();
        StringBuilder querieMainBody = new StringBuilder();
        StringBuilder querieMainValues = new StringBuilder();
        String classFullName = modelPath + "." + (String)data.get("class");
        HashMap pack = (HashMap)data.get("data");
        Class<?> entityClass = Class.forName(classFullName);
        Table table = entityClass.getAnnotation(Table.class);
        String tableName = table.name();
        HashMap fields = UtilAbstractObjectBuilder.extractFields(entityClass);
        querieMainBody.append("UPDATE OR INSERT INTO ").append(tableName).append("(");
        querieMainValues.append(") VALUES (");
        Set keys = pack.keySet();
        for (String key : keys) {
            Method getMethod;
            Object value = pack.get(key);
            Field field = (Field)fields.get(key);
            if (field == null || (getMethod = UtilAbstractObjectBuilder.searchMethod(UtilAbstractObjectBuilder.extractMethodName("get", field.getName()), entityClass)) == null || value instanceof ArrayList) continue;
            if (!querieMainBody.toString().endsWith("(")) {
                querieMainBody.append(" ,");
            }
            if (!querieMainValues.toString().endsWith("(")) {
                querieMainValues.append(" ,");
            }
            if (getMethod.getAnnotation(Column.class) != null) {
                querieMainBody.append(getMethod.getAnnotation(Column.class).name());
            } else if (getMethod.getAnnotation(JoinColumn.class) != null) {
                querieMainBody.append(getMethod.getAnnotation(JoinColumn.class).name());
            } else if (getMethod.getAnnotation(JoinTable.class) != null) {
                querieMainBody.append(getMethod.getAnnotation(JoinTable.class).name());
            }
            querieMainValues.append(UtilAbstractObjectBuilder.getStringSQLValue(value));
        }
        queries.add(querieMainBody.toString().toUpperCase() + querieMainValues.toString() + ");");
        queries.addAll(queriesList);
        return queries;
    }

    public static Method searchMethod(String methodName, Class entity) throws ClassNotFoundException {
        for (Method m : entity.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        for (Method m : entity.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public static Method searchMethod(String methodName, Class entity, Integer parameterLength) throws ClassNotFoundException {
        for (Method m : entity.getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != parameterLength) continue;
            return m;
        }
        for (Method m : entity.getDeclaredMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != parameterLength) continue;
            return m;
        }
        return null;
    }

    public static Field searchField(String fieldName, Object entity) throws ClassNotFoundException {
        for (Field f : entity.getClass().getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    public static Field searchField(String fieldName, Class entity) throws ClassNotFoundException {
        for (Field f : entity.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    public static Object simpleFindByCriterials(String className, Session session, List keys) throws ClassNotFoundException {
        List list = UtilAbstractCachedFind.simpleFindByCriterialsOnCache(className, session, keys);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static Object simpleFindByCriterials(String className, Session session, List<Criterion> keys, List<Order> order) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        Criteria crit = session.createCriteria(c);
        crit.setCacheable(true);
        for (Criterion Criterion2 : keys) {
            crit.add(Criterion2);
        }
        for (Order o : order) {
            crit.addOrder(o);
        }
        return crit.list();
    }

    public static Object simpleFindByCriterialsHql(String className, Session session, List keys) throws ClassNotFoundException {
        Query query = session.createQuery(UtilAbstractObjectBuilder.buildQuery(className, keys));
        List list = query.list();
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static List simpleFindByCriterialsList(String className, Session session, List<Criterion> keys) throws ClassNotFoundException {
        return UtilAbstractCachedFind.simpleFindByCriterialsOnCache(className, session, keys);
    }

    public static List simpleFindByCriterialsList(String className, Session session, List<Criterion> keys, Integer start) throws ClassNotFoundException {
        return UtilAbstractCachedFind.simpleFindByCriterialsOnCache(className, session, keys, start);
    }

    public static List simpleFindAll(String className, Session session) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        Criteria crit = session.createCriteria(c);
        return crit.list();
    }

    public static Object simpleFindByPrimaryKey(String className, Session session, Object key) throws ClassNotFoundException {
        ArrayList<SimpleExpression> crit = new ArrayList<SimpleExpression>();
        Class<?> c = Class.forName(className);
        Method m = UtilAbstractObjectBuilder.searchIdMethod(c);
        String fieldName = UtilAbstractObjectBuilder.extractFieldName(m);
        crit.add(Restrictions.eq((String)fieldName, (Object)key));
        return UtilAbstractObjectBuilder.simpleFindByCriterials(className, session, crit);
    }

    public static List<SimpleExpression> extractUniqueKeys(Class c, HashMap pack) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<SimpleExpression> keys = new ArrayList<SimpleExpression>();
        Table table = c.getAnnotation(Table.class);
        if (table != null) {
            for (UniqueConstraint unique : table.uniqueConstraints()) {
                for (String columnName : unique.columnNames()) {
                    SimpleExpression crit = UtilAbstractObjectBuilder.extractRestriction(c, columnName, pack);
                    keys.add(crit);
                }
            }
        }
        return keys;
    }

    public static List<SimpleExpression> extractUniqueKeysSync(Class c, HashMap pack) throws ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<SimpleExpression> keys = new ArrayList<SimpleExpression>();
        SyncUniqueKeys syncUniqueKeys = c.getAnnotation(SyncUniqueKeys.class);
        if (syncUniqueKeys != null) {
            for (String key : syncUniqueKeys.keys()) {
                SimpleExpression crit = UtilAbstractObjectBuilder.extractRestriction(key, pack);
                keys.add(crit);
            }
        }
        return keys;
    }

    private static String getStringSQLValue(Object value) {
        Object object = value = value != null ? value : "NULL";
        if (value instanceof String) {
            return value == "NULL" ? value.toString() : "'" + value.toString() + "'";
        }
        if (value instanceof Timestamp) {
            return "'" + ContatoDateUtil.dateToStr((Date)((Timestamp)value), "dd.MM.yyyy, HH:mm:ss") + "'";
        }
        if (value instanceof Date) {
            return "'" + ContatoDateUtil.dateToStr((Date)value, "dd.MM.yyyy") + "'";
        }
        return value.toString();
    }

    private static Object createInstance(Class c, HashMap data, Session session) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException {
        Object instanceList = data.get("listObject");
        Object instanceFather = data.get("fatherObject");
        if (instanceList != null) {
            return instanceList;
        }
        if (instanceFather != null) {
            return instanceFather;
        }
        return UtilAbstractObjectBuilder.searchInstance(c, data, session);
    }

    private static Object searchInstance(Class c, HashMap data, Session session) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IllegalArgumentException, InvocationTargetException {
        HashMap pack = (HashMap)data.get("data");
        String fieldFather = (String)data.get("fieldFather");
        String fieldName = (String)data.get("fieldName");
        List<SimpleExpression> keys = UtilAbstractObjectBuilder.extractUniqueKeys(c, pack);
        List<SimpleExpression> keysHql = UtilAbstractObjectBuilder.extractUniqueKeysSync(c, pack);
        Object instance = pack.get(fieldFather);
        if (instance != null) {
            Field field = UtilAbstractObjectBuilder.searchField(fieldName, instance);
            field.setAccessible(true);
            instance = field.get(instance);
            if (instance != null) {
                List children = (List)instance;
                for (Object child : children) {
                    Boolean isMatch = true;
                    for (Criterion criterion : keys) {
                        Field nameField = UtilAbstractObjectBuilder.searchField("propertyName", criterion);
                        Field valueField = UtilAbstractObjectBuilder.searchField("value", criterion);
                        nameField.setAccessible(true);
                        valueField.setAccessible(true);
                        String name = (String)nameField.get(criterion);
                        Object value = valueField.get(criterion);
                        Object holder = null;
                        for (String criteria : UtilAbstractObjectBuilder.splitCriteria(name)) {
                            Field f;
                            if (holder == null) {
                                f = UtilAbstractObjectBuilder.searchField(criteria, child);
                                f.setAccessible(true);
                                holder = f.get(child);
                                continue;
                            }
                            f = UtilAbstractObjectBuilder.searchField(criteria, holder);
                            f.setAccessible(true);
                            holder = f.get(holder);
                        }
                        if (holder.equals(value)) continue;
                        isMatch = false;
                    }
                    if (!isMatch.booleanValue()) continue;
                    return child;
                }
            }
        } else if (keys != null && !keys.isEmpty()) {
            instance = UtilAbstractObjectBuilder.simpleFindByCriterials(c.getName(), session, keys);
        } else if (keysHql != null && !keysHql.isEmpty()) {
            instance = UtilAbstractObjectBuilder.simpleFindByCriterialsHql(c.getName(), session, keysHql);
        }
        if (instance == null) {
            instance = c.newInstance();
        }
        return instance;
    }

    private static List<String> splitCriteria(String name) {
        ArrayList<String> criterials = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.substring(i, i + 1).equals(".")) {
                criterials.add(buffer.toString());
                buffer = new StringBuilder();
                continue;
            }
            buffer.append(name.substring(i, i + 1));
        }
        criterials.add(buffer.toString());
        return criterials;
    }

    public static HashMap extractFields(Class c) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field o : c.getDeclaredFields()) {
            fields.put(o.getName(), o);
        }
        return fields;
    }

    private static HashMap extractMethods(Class entity) {
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Method m : entity.getDeclaredMethods()) {
            methods.put(m.getName(), m);
        }
        return methods;
    }

    private static SimpleExpression extractRestriction(String keys, HashMap pack) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        String currentValue = null;
        for (String criteria : UtilAbstractObjectBuilder.splitCriteria(keys)) {
            if (currentValue == null) {
                currentValue = pack.get(criteria);
                continue;
            }
            if (!(currentValue instanceof HashMap)) continue;
            currentValue = ((HashMap)((Object)currentValue)).get("data");
            currentValue = ((HashMap)((Object)currentValue)).get(criteria);
        }
        if (currentValue instanceof String) {
            currentValue = "'" + (String)currentValue + "'";
        }
        return Restrictions.eq((String)keys, currentValue);
    }

    private static SimpleExpression extractRestriction(Class c, String columnName, HashMap pack) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        HashMap methods = UtilAbstractObjectBuilder.extractMethods(c);
        Set keys = methods.keySet();
        for (String key : keys) {
            JoinColumn joinColumn;
            Method method = (Method)methods.get(key);
            if (method.getAnnotation(Column.class) != null) {
                Column column = method.getAnnotation(Column.class);
                if (!column.name().equalsIgnoreCase(columnName)) continue;
                Object fieldName = UtilAbstractObjectBuilder.extractFieldName(method);
                fieldName = ((String)fieldName).substring(0, 1).toLowerCase() + ((String)fieldName).substring(1);
                return Restrictions.eq((String)fieldName, pack.get(fieldName));
            }
            if (method.getAnnotation(JoinColumn.class) == null || !(joinColumn = method.getAnnotation(JoinColumn.class)).name().equalsIgnoreCase(columnName)) continue;
            Object fieldName = UtilAbstractObjectBuilder.extractFieldName(method);
            Object value = pack.get(fieldName = ((String)fieldName).substring(0, 1).toLowerCase() + ((String)fieldName).substring(1));
            if (value instanceof Long) {
                return Restrictions.eq((String)((String)fieldName + ".identificador"), value);
            }
            Field field = UtilAbstractObjectBuilder.searchField("identificador", value);
            field.setAccessible(true);
            value = field.get(value);
            return Restrictions.eq((String)((String)fieldName + ".identificador"), value);
        }
        return null;
    }

    public static Method searchIdMethod(Class entity) throws ClassNotFoundException {
        for (Method m : entity.getDeclaredMethods()) {
            if (m.getAnnotation(Id.class) == null) continue;
            return m;
        }
        return null;
    }

    public static Boolean isRequired(Field field, Object entity) throws ClassNotFoundException {
        RequiredSync annotation = field.getType().getAnnotation(RequiredSync.class);
        Field f = UtilAbstractObjectBuilder.searchField(UtilAbstractObjectBuilder.extractFieldName(entity), field.getType());
        if (annotation != null && annotation.required() && (!annotation.mappedBy().isEmpty() && annotation.mappedBy().equals(UtilAbstractObjectBuilder.extractFieldName(entity)) || f == null)) {
            return true;
        }
        return false;
    }

    public static String extractFieldName(Object entity) {
        return entity.getClass().getSimpleName().substring(0, 1).toLowerCase() + entity.getClass().getSimpleName().substring(1);
    }

    private static String extractFieldName(Method m) {
        Object fieldName = m.getName().replace("get", "");
        fieldName = ((String)fieldName).replace("set", "");
        fieldName = ((String)fieldName).substring(0, 1).toLowerCase() + ((String)fieldName).substring(1);
        return fieldName;
    }

    private static Boolean generateID(Class c) {
        RequiredSync annotation = c.getAnnotation(RequiredSync.class);
        if (annotation != null && annotation.generateID()) {
            return false;
        }
        return true;
    }

    public static String extractMethodName(String getSet, String fieldName) {
        return getSet + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static String buildQuery(String className, List<Criterion> keys) {
        StringBuilder query = new StringBuilder();
        int count = 0;
        query.append("from ").append(className).append(" ");
        query.append("where ");
        for (Criterion crit : keys) {
            if (count > 0) {
                query.append(" and ");
            }
            query.append(crit.toString());
            ++count;
        }
        return query.toString();
    }

    public static Object getListObject(List objects, HashMap entity) throws ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap entityData = (HashMap)entity.get("data");
        if (objects != null) {
            for (Object o : objects) {
                Field identificador;
                Field gradeCor;
                Field nrItem = UtilAbstractObjectBuilder.searchField("nrItem", o);
                if (nrItem != null) {
                    nrItem.setAccessible(true);
                    if (nrItem.get(o).equals(entityData.get("nrItem"))) {
                        return o;
                    }
                }
                if ((gradeCor = UtilAbstractObjectBuilder.searchField("gradeCor", o)) != null) {
                    gradeCor.setAccessible(true);
                    Object gradeCorObject = gradeCor.get(o);
                    Method identificador2 = UtilAbstractObjectBuilder.searchIdMethod(gradeCor.getType());
                    if (identificador2.invoke(gradeCorObject, (Object[])null).equals(entityData.get("gradeCor"))) {
                        return o;
                    }
                }
                if ((identificador = UtilAbstractObjectBuilder.searchField("identificador", o)) == null || entityData.get("identificador") == null) continue;
                identificador.setAccessible(true);
                if (!entityData.get("identificador").equals(identificador.get(o))) continue;
                return o;
            }
        }
        return null;
    }
}

