/*
 * Decompiled with CFR 0.152.
 */
package contato.dialog;

import contato.dialog.DialogsHelperDateInputFrame;
import contato.dialog.DialogsHelperDoubleInputFrame;
import contato.dialog.DialogsHelperFrame;
import contato.dialog.DialogsHelperHiddenTextInputFrame;
import contato.dialog.DialogsHelperTextBigSizeFrame;
import contato.dialog.DialogsHelperTextValidSizeInputFrame;
import contato.swing.ContatoButton;
import contato.swing.ContatoDialog;
import contato.swing.ContatoLabel;
import contato.swing.ContatoPanel;
import contato.swing.ContatoScrollPane;
import contato.swing.ContatoTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ContatoDialogsHelper {
    public static void showError(String errorMessage) {
        Toolkit.getDefaultToolkit().beep();
        System.out.println(FocusManager.getCurrentManager().getActiveWindow());
        JOptionPane.showMessageDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(errorMessage), "Erro", 0);
    }

    public static void main(String[] args) {
        ContatoDialogsHelper.showError((Component)null, "teste");
    }

    public static void showError(Component component, String errorMessage) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(component, ContatoDialogsHelper.getFormattedMessage(errorMessage), "Erro", 0, null);
    }

    public static String showInputDialog(String message, String title) {
        Toolkit.getDefaultToolkit().beep();
        return JOptionPane.showInputDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(message), title, 3);
    }

    public static Object showInputDialog(String message, String title, Object[] valores) {
        Toolkit.getDefaultToolkit().beep();
        return JOptionPane.showInputDialog(FocusManager.getCurrentManager().getActiveWindow(), message, title, 3, null, valores, null);
    }

    public static Integer showInputInt(String msg, Integer initValue) {
        initValue = initValue != null ? initValue : 0;
        String text = JOptionPane.showInputDialog(FocusManager.getCurrentManager().getActiveWindow(), msg, String.valueOf(initValue));
        try {
            return Integer.valueOf(text);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String showInputDialog(String message, String title, String initialValue) {
        Toolkit.getDefaultToolkit().beep();
        return JOptionPane.showInputDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(message), initialValue);
    }

    public static void showFlashMessage(String string, final long i) {
        final ContatoDialog cd = new ContatoDialog();
        ContatoScrollPane cs = new ContatoScrollPane();
        ContatoTextArea cx = new ContatoTextArea();
        cx.setEditable(false);
        cx.setText(string);
        cd.setContentPane(cs);
        cs.setViewportView(cx);
        cd.setSize(500, 200);
        cd.setLocationRelativeTo(null);
        cd.setModal(false);
        cd.setUndecorated(true);
        cd.setVisible(true);
        cd.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                cd.dispose();
            }
        });
        Runnable tq = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(i);
                    cd.dispose();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ContatoDialogsHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        SwingUtilities.invokeLater(tq);
    }

    public static void showFlashMessage(String string, final long i, Dimension d) {
        final ContatoDialog cd = new ContatoDialog();
        ContatoScrollPane cs = new ContatoScrollPane();
        ContatoTextArea cx = new ContatoTextArea();
        cx.setEditable(false);
        cx.setText(string);
        cd.setContentPane(cs);
        cs.setViewportView(cx);
        cd.setSize(d);
        cd.setLocationRelativeTo(null);
        cd.setModal(false);
        cd.setUndecorated(true);
        cd.setVisible(true);
        cd.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                cd.dispose();
            }
        });
        Runnable tq = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(i);
                    cd.dispose();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ContatoDialogsHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        SwingUtilities.invokeLater(tq);
    }

    public static String showInputDialog(Component comp, String message, String title) {
        Toolkit.getDefaultToolkit().beep();
        return JOptionPane.showInputDialog(comp, ContatoDialogsHelper.getFormattedMessage(message), title, 3);
    }

    public static void showError(String errorMessage, String title) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(errorMessage), title, 0, null);
    }

    public static int showQuestion(String question) {
        Toolkit.getDefaultToolkit().beep();
        Object[] options = new Object[]{"Sim", "N\u00e3o"};
        return JOptionPane.showOptionDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(question), "Pergunta", 0, 3, null, options, options[0]);
    }

    public static int showQuestion(Component comp, String question) {
        Object[] options = new Object[]{"Sim", "N\u00e3o"};
        Toolkit.getDefaultToolkit().beep();
        return JOptionPane.showOptionDialog(comp, ContatoDialogsHelper.getFormattedMessage(question), "Pergunta", 0, 3, null, options, options[0]);
    }

    public static void showWarning(String msg) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(msg), "Aten\u00e7\u00e3o", 2, null);
    }

    public static int showQuestionNotFocusable(String msg) {
        return DialogsHelperFrame.showInfo(msg);
    }

    public static int showBigInfo(String msg) {
        return DialogsHelperFrame.showBigInfo(msg);
    }

    public static int showBigInfo(String msg, String title) {
        return DialogsHelperFrame.showBigInfo(msg, title);
    }

    public static int showBigInfo(String msg, String detail, String title) {
        return DialogsHelperFrame.showBigInfo(msg, detail, title);
    }

    public static String showInputDialogBig(String title, String content) {
        return DialogsHelperTextBigSizeFrame.showTextInput(title, content);
    }

    public static String showInputDialogBig(String title) {
        return DialogsHelperTextBigSizeFrame.showTextInput(title);
    }

    public static Date showInputDate(String msg) {
        return DialogsHelperDateInputFrame.showDateInput(msg);
    }

    public static Date showInputDate(String msg, Date dataIn) {
        return DialogsHelperDateInputFrame.showDateInput(msg, dataIn);
    }

    public static Double showInputDouble(String msg, double valorInicial) {
        return DialogsHelperDoubleInputFrame.showDoubleInput(msg, valorInicial);
    }

    public static Double showInputDouble(String msg, double valorInicial, int casasDecimais) {
        return DialogsHelperDoubleInputFrame.showDoubleInput(msg, valorInicial, casasDecimais);
    }

    public static String showInputPassword(String msg) {
        return DialogsHelperHiddenTextInputFrame.showHiddenTextInput(msg);
    }

    public static String showInputTextValidSize(String msg, int tamanhoMaximo) {
        return DialogsHelperTextValidSizeInputFrame.showHiddenTextInput(msg, tamanhoMaximo);
    }

    public static void showInfo(String msg) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(msg), "Informa\u00e7\u00e3o", 1, null);
    }

    public static void showInfo(String msg, Boolean focusOnOKButton) {
        if (!focusOnOKButton.booleanValue()) {
            Toolkit.getDefaultToolkit().beep();
            JDialog dialog = new JDialog((Frame)new JFrame(), true);
            ContatoPanel panel = ContatoDialogsHelper.buildPanel(msg, dialog);
            dialog.setTitle("Informa\u00e7\u00e3o");
            dialog.setAlwaysOnTop(false);
            dialog.add(panel);
            dialog.setSize(panel.getSize());
            dialog.setPreferredSize(panel.getPreferredSize());
            dialog.setMinimumSize(panel.getMinimumSize());
            dialog.setMaximumSize(panel.getMaximumSize());
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        } else {
            ContatoDialogsHelper.showInfo(msg);
        }
    }

    public static void showError(String errorMessage, Boolean focusOnOKButton) {
        if (!focusOnOKButton.booleanValue()) {
            Toolkit.getDefaultToolkit().beep();
            JDialog dialog = new JDialog((Frame)new JFrame(), true);
            ContatoPanel panel = ContatoDialogsHelper.buildPanel(errorMessage, dialog);
            dialog.setTitle("Erro");
            dialog.setAlwaysOnTop(false);
            dialog.add(panel);
            dialog.setSize(panel.getSize());
            dialog.setPreferredSize(panel.getPreferredSize());
            dialog.setMinimumSize(panel.getMinimumSize());
            dialog.setMaximumSize(panel.getMaximumSize());
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        } else {
            ContatoDialogsHelper.showError(errorMessage);
        }
    }

    private static ContatoPanel buildPanel(String message, JDialog dialog) {
        ContatoPanel panel = new ContatoPanel();
        panel.setLayout(new GridBagLayout());
        ContatoLabel label = new ContatoLabel(message);
        label.setIcon(new ImageIcon(label.getClass().getResource("/images/attention2.png")));
        panel.add((Component)label, ContatoDialogsHelper.buildGridBagLayout(0, 0, 0, 0, 0, 10));
        panel.add((Component)ContatoDialogsHelper.buildButton(dialog), ContatoDialogsHelper.buildGridBagLayout(0, 1, 1, 1, 0, 10));
        Dimension dimension = new Dimension(450, 120);
        panel.setSize(dimension);
        panel.setPreferredSize(dimension);
        panel.setMinimumSize(dimension);
        panel.setMaximumSize(dimension);
        return panel;
    }

    private static ContatoButton buildButton(final JDialog dialog) {
        ContatoButton button = new ContatoButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        return button;
    }

    private static GridBagConstraints buildGridBagLayout(Integer gridX, Integer gridY, Integer weightX, Integer weightY, Integer fill, Integer anchor) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridX;
        gridBagConstraints.gridy = gridY;
        gridBagConstraints.weightx = weightX.intValue();
        gridBagConstraints.weighty = weightY.intValue();
        gridBagConstraints.anchor = anchor;
        gridBagConstraints.fill = fill;
        gridBagConstraints.insets.top = 7;
        return gridBagConstraints;
    }

    public static void showInfo(String title, String msg) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(msg), title, 1, null);
    }

    public static void showInfo(Component comp, String msg) {
        Toolkit.getDefaultToolkit().beep();
        JOptionPane.showMessageDialog(comp, ContatoDialogsHelper.getFormattedMessage(msg), "Informa\u00e7\u00e3o", 1, null);
    }

    public static int showQuestion(String question, String title) {
        Toolkit.getDefaultToolkit().beep();
        Object[] options = new Object[]{"Sim", "N\u00e3o"};
        return JOptionPane.showOptionDialog(FocusManager.getCurrentManager().getActiveWindow(), ContatoDialogsHelper.getFormattedMessage(question), "Pergunta", 0, 3, null, options, options[0]);
    }

    private static String getFormattedMessage(String message) {
        double widthScreen;
        if (message == null) {
            return message;
        }
        JLabel l = new JLabel(message);
        StringBuffer st = new StringBuffer(message);
        int width = l.getFontMetrics(l.getFont()).stringWidth(message);
        if ((double)width > (widthScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth() - 30.0)) {
            int divisor;
            int size = (int)Math.ceil((double)width / widthScreen);
            for (int cumulate = divisor = st.length() / size; cumulate < st.length(); cumulate += divisor) {
                st.insert(cumulate, "\n");
            }
        }
        return st.toString();
    }
}

