/*
 * Decompiled with CFR 0.152.
 */
package contato.jasperreports.java2d;

import contato.jasperreports.java2d.JBookPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;

public class Jaspers2DPagesFrame
extends JFrame {
    private JasperPrint jrPrint = null;
    private JRGraphics2DExporter exporter = null;
    private Point pageSize = new Point(350, 472);
    JBookPanel jBookPanel1;

    public Jaspers2DPagesFrame(JasperPrint jrPrint, int nrFolhas) {
        this.initAll(jrPrint);
        this.setTitle(this.getTitle() + ": N\u00famero de p\u00e1ginas: " + jrPrint.getPages().size() + " N\u00famero de folhas: " + nrFolhas);
    }

    public void initAll(JasperPrint jrPrint) {
        this.initComponents();
        this.jrPrint = jrPrint;
        try {
            this.exporter = new JRGraphics2DExporter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDefaultCloseOperation(2);
        this.setSize(800, 600);
        this.jBookPanel1 = new JBookPanel(){

            @Override
            protected Image loadPage(int index) {
                BufferedImage img = new BufferedImage(Jaspers2DPagesFrame.this.getPageSize().x, Jaspers2DPagesFrame.this.getPageSize().y, 1);
                Graphics gfx = img.getGraphics();
                Jaspers2DPagesFrame.this.exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)Jaspers2DPagesFrame.this.getJrPrint());
                Jaspers2DPagesFrame.this.exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)new Integer(index));
                Jaspers2DPagesFrame.this.exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)gfx);
                Jaspers2DPagesFrame.this.exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.ZOOM_RATIO, (Object)new Float((float)Jaspers2DPagesFrame.this.getPageSize().x / (float)Jaspers2DPagesFrame.this.getJrPrint().getPageWidth()));
                try {
                    Jaspers2DPagesFrame.this.exporter.exportReport();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return img;
            }
        };
        this.jBookPanel1.setMargins(30, 40);
        this.jBookPanel1.setBackground(new Color(157, 185, 235));
        this.jBookPanel1.setLeftPageIndex(-1);
        this.getContentPane().add((Component)this.jBookPanel1, "Center");
        this.updateViewerSize();
    }

    public JasperPrint getJrPrint() {
        return this.jrPrint;
    }

    void updateViewerSize() {
        System.out.println("Updating page size: " + String.valueOf(this.getPageSize()));
        System.out.flush();
        int imageWidth = this.jrPrint.getPageWidth();
        int imageHeight = this.jrPrint.getPageHeight();
        int width = this.getContentPane().getWidth() / 2 - 40;
        int height = this.getContentPane().getHeight() - 60;
        if (imageWidth <= width && imageHeight <= height) {
            this.getPageSize().x = width;
            this.getPageSize().y = height;
        } else if (width > 0 && height > 0) {
            if ((double)imageWidth / (double)width > (double)imageHeight / (double)height) {
                this.getPageSize().x = width;
                this.getPageSize().y = Math.min(imageHeight * width / imageWidth, height);
            } else {
                this.getPageSize().x = Math.min(imageWidth * height / imageHeight, width);
                this.getPageSize().y = height;
            }
        }
        int index = -1;
        index = this.jBookPanel1.getLeftPageIndex();
        this.jBookPanel1.setPages("", "", "", this.jrPrint.getPages().size() - 1, this.getPageSize().x, this.getPageSize().y);
        this.jBookPanel1.setLeftPageIndex(index);
        System.out.println("New size: " + String.valueOf(this.getPageSize()));
        System.out.flush();
    }

    public void setJrPrint(JasperPrint jrPrint) {
        this.jrPrint = jrPrint;
    }

    public JRGraphics2DExporter getExporter() {
        return this.exporter;
    }

    public void setExporter(JRGraphics2DExporter exporter) {
        this.exporter = exporter;
    }

    public Point getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Point pageSize) {
        this.pageSize = pageSize;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Previsualiza\u00e7\u00e3o");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                Jaspers2DPagesFrame.this.formComponentResized(evt);
            }
        });
        this.pack();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.updateViewerSize();
    }
}

