/*
 * Decompiled with CFR 0.152.
 */
package contato.jasperreports.print;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoOpenToolsException;
import contato.swing.ContatoButton;
import contato.swing.ContatoComboBox;
import contato.swing.ContatoIntegerTextField;
import contato.swing.ContatoLabel;
import contato.swing.ContatoMenuBar;
import contato.swing.ContatoMenuItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class InfoPrintCommonFilesDialog
extends JDialog {
    private byte[] print;
    private ContatoButton btnImprimir;
    private ContatoComboBox cmbImpressoras;
    private ContatoLabel contatoLabel1;
    private ContatoLabel contatoLabel3;
    private ContatoLabel contatoLabel4;
    private ContatoMenuBar contatoMenuBar1;
    private ContatoMenuItem contatoMenuItem1;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private ContatoIntegerTextField txtNrCopias;

    public InfoPrintCommonFilesDialog(byte[] print, String printerName) throws ContatoOpenToolsException, PrinterException {
        this.initComponents();
        this.print = print;
        this.txtNrCopias.setInteger(1);
        this.setDefaultCloseOperation(2);
        this.initPrinterJobs(printerName);
        this.setTitle("Impress\u00e3o");
        this.btnImprimir.requestFocus();
    }

    private void initComponents() {
        this.contatoLabel1 = new ContatoLabel();
        this.contatoLabel3 = new ContatoLabel();
        this.txtNrCopias = new ContatoIntegerTextField();
        this.cmbImpressoras = new ContatoComboBox();
        this.btnImprimir = new ContatoButton();
        this.contatoLabel4 = new ContatoLabel();
        this.contatoMenuBar1 = new ContatoMenuBar();
        this.jMenu1 = new JMenu();
        this.contatoMenuItem1 = new ContatoMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.contatoLabel1.setText("Impressora");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this.contatoLabel1, gridBagConstraints);
        this.contatoLabel3.setText("Tecle Esc para sair / I para imprimir");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.contatoLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.getContentPane().add((Component)this.txtNrCopias, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.getContentPane().add((Component)this.cmbImpressoras, gridBagConstraints);
        this.btnImprimir.setMnemonic(73);
        this.btnImprimir.setText("Imprimir");
        this.btnImprimir.setFocusable(true);
        this.btnImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPrintCommonFilesDialog.this.btnImprimirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.btnImprimir, gridBagConstraints);
        this.contatoLabel4.setText("C\u00f3pias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this.contatoLabel4, gridBagConstraints);
        this.jMenu1.setText("Op\u00e7\u00f5es");
        this.contatoMenuItem1.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.contatoMenuItem1.setText("Sair");
        this.contatoMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPrintCommonFilesDialog.this.contatoMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.contatoMenuItem1);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(73, 0));
        this.jMenuItem1.setText("Imprimir");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPrintCommonFilesDialog.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.contatoMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.contatoMenuBar1);
    }

    private void btnImprimirActionPerformed(ActionEvent evt) {
        this.printAndDispose();
    }

    private void contatoMenuItem1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.printAndDispose();
    }

    public void print() throws Exception {
        if (this.cmbImpressoras.getSelectedItem() == null) {
            ContatoDialogsHelper.showError("Primeiro, selecione uma impressora.");
            return;
        }
        if (this.txtNrCopias.getInteger() < 1) {
            ContatoDialogsHelper.showError("N\u00famero de c\u00f3pias deve ser maior que 0.");
            return;
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintService(printJob.getPrintService());
        printJob.setPrintService((PrintService)this.cmbImpressoras.getSelectedItem());
        for (int j = 0; j < this.txtNrCopias.getInteger(); ++j) {
            this.printAll((PrintService)this.cmbImpressoras.getSelectedItem());
        }
        this.dispose();
    }

    private void initPrinterJobs(String printerName) throws ContatoOpenToolsException, PrinterException {
        PrintService[] p = PrinterJob.lookupPrintServices();
        if (p == null || p.length < 1) {
            throw new ContatoOpenToolsException("Nenhuma impressora encontrada!");
        }
        DefaultComboBoxModel<PrintService> d = new DefaultComboBoxModel<PrintService>(p);
        this.cmbImpressoras.setModel(d);
        if (printerName == null) {
            printerName = PrintServiceLookup.lookupDefaultPrintService().getName();
        }
        for (int i = 0; i < d.getSize(); ++i) {
            PrintService pf = d.getElementAt(i);
            if (pf == null || !pf.getName().equalsIgnoreCase(printerName)) continue;
            this.cmbImpressoras.setSelectedIndex(i);
            break;
        }
    }

    private void printAll(PrintService service) throws Exception {
        String defaultPrinter = PrintServiceLookup.lookupDefaultPrintService().getName();
        System.out.println("Default printer: " + defaultPrinter);
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        pras.add(new Copies(1));
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        SimpleDoc doc = new SimpleDoc(this.print, flavor, null);
        DocPrintJob job = service.createPrintJob();
        job.print(doc, pras);
    }

    public ContatoButton getBtnImprimir() {
        return this.btnImprimir;
    }

    public void setBtnImprimir(ContatoButton btnImprimir) {
        this.btnImprimir = btnImprimir;
    }

    private void printAndDispose() {
        try {
            this.print();
            this.dispose();
        }
        catch (Exception ex) {
            ContatoDialogsHelper.showError("Erro ao imprimir. \n" + ex.getMessage());
            Logger.getLogger(InfoPrintCommonFilesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

