/*
 * Decompiled with CFR 0.152.
 */
package contato.jasperreports.print;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoOpenToolsException;
import contato.jasperreports.print.ContatoJasperReportsJRPrinterAWT;
import contato.swing.ContatoButton;
import contato.swing.ContatoCheckBox;
import contato.swing.ContatoComboBox;
import contato.swing.ContatoIntegerTextField;
import contato.swing.ContatoLabel;
import contato.swing.ContatoMenuBar;
import contato.swing.ContatoMenuItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.type.OrientationEnum;

public class InfoPrintDialog
extends JDialog {
    private JasperPrint print;
    private JasperPrint print2;
    private ContatoButton btnImprimir;
    private ContatoCheckBox chcImprimirFrenteVerso;
    private ContatoComboBox cmbImpressoras;
    private ContatoLabel contatoLabel1;
    private ContatoLabel contatoLabel2;
    private ContatoLabel contatoLabel3;
    private ContatoLabel contatoLabel4;
    private ContatoMenuBar contatoMenuBar1;
    private ContatoMenuItem contatoMenuItem1;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private ContatoIntegerTextField txtNrCopias;
    private ContatoIntegerTextField txtNrPaginas;

    public InfoPrintDialog(JasperPrint print, String printerName) throws ContatoOpenToolsException, PrinterException {
        this.constructor(printerName, print, null);
    }

    public InfoPrintDialog(JasperPrint print, JasperPrint print2, String printerName) throws ContatoOpenToolsException, PrinterException {
        this.constructor(printerName, print, print2);
    }

    private void constructor(String printerName, JasperPrint print, JasperPrint print2) throws ContatoOpenToolsException, PrinterException {
        this.initComponents();
        this.print = print;
        this.print2 = print2;
        this.txtNrPaginas.setReadOnly();
        this.txtNrCopias.setInteger(1);
        this.txtNrPaginas.setEditable(false);
        this.setDefaultCloseOperation(2);
        this.initPrinterJobs(printerName);
        this.txtNrPaginas.setInteger(print.getPages().size());
        if (print.getPages().size() <= 1) {
            this.chcImprimirFrenteVerso.setEnabled(false);
        }
        this.setTitle("Impress\u00e3o");
        this.btnImprimir.requestFocus();
    }

    private void initComponents() {
        this.contatoLabel1 = new ContatoLabel();
        this.contatoLabel2 = new ContatoLabel();
        this.txtNrPaginas = new ContatoIntegerTextField();
        this.contatoLabel3 = new ContatoLabel();
        this.txtNrCopias = new ContatoIntegerTextField();
        this.cmbImpressoras = new ContatoComboBox();
        this.chcImprimirFrenteVerso = new ContatoCheckBox();
        this.btnImprimir = new ContatoButton();
        this.contatoLabel4 = new ContatoLabel();
        this.contatoMenuBar1 = new ContatoMenuBar();
        this.jMenu1 = new JMenu();
        this.contatoMenuItem1 = new ContatoMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.contatoLabel1.setText("Impressora");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this.contatoLabel1, gridBagConstraints);
        this.contatoLabel2.setText("P\u00e1ginas");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this.contatoLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.getContentPane().add((Component)this.txtNrPaginas, gridBagConstraints);
        this.contatoLabel3.setText("Tecle Esc para sair / I para imprimir");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.contatoLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.getContentPane().add((Component)this.txtNrCopias, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.getContentPane().add((Component)this.cmbImpressoras, gridBagConstraints);
        this.chcImprimirFrenteVerso.setText("Imprimir Frente e Verso");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 0);
        this.getContentPane().add((Component)this.chcImprimirFrenteVerso, gridBagConstraints);
        this.btnImprimir.setMnemonic(73);
        this.btnImprimir.setText("Imprimir");
        this.btnImprimir.setFocusable(true);
        this.btnImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPrintDialog.this.btnImprimirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.btnImprimir, gridBagConstraints);
        this.contatoLabel4.setText("C\u00f3pias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)this.contatoLabel4, gridBagConstraints);
        this.jMenu1.setText("Op\u00e7\u00f5es");
        this.contatoMenuItem1.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.contatoMenuItem1.setText("Sair");
        this.contatoMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPrintDialog.this.contatoMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.contatoMenuItem1);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(73, 0));
        this.jMenuItem1.setText("Imprimir");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPrintDialog.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.contatoMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.contatoMenuBar1);
    }

    private void btnImprimirActionPerformed(ActionEvent evt) {
        this.printAndDispose(this.print);
        if (this.print2 != null) {
            this.printAndDispose(this.print2);
        }
    }

    private void contatoMenuItem1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.printAndDispose(this.print);
        if (this.print2 != null) {
            this.printAndDispose(this.print2);
        }
    }

    public void print(JasperPrint print) throws PrinterException, JRException {
        if (this.cmbImpressoras.getSelectedItem() == null) {
            ContatoDialogsHelper.showError("Primeiro, selecione uma impressora.");
            return;
        }
        if (this.txtNrCopias.getInteger() < 1) {
            ContatoDialogsHelper.showError("N\u00famero de c\u00f3pias deve ser maior que 0.");
            return;
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintService(printJob.getPrintService());
        printJob.setPrintService((PrintService)this.cmbImpressoras.getSelectedItem());
        for (int j = 0; j < this.txtNrCopias.getInteger(); ++j) {
            if (this.chcImprimirFrenteVerso.isSelected()) {
                this.printParImpar(printJob, print);
                continue;
            }
            this.printAll(printJob, print);
        }
        this.dispose();
    }

    private void initPrinterJobs(String printerName) throws ContatoOpenToolsException, PrinterException {
        PrintService[] p = PrinterJob.lookupPrintServices();
        if (p == null || p.length < 1) {
            throw new ContatoOpenToolsException("Nenhuma impressora encontrada!");
        }
        DefaultComboBoxModel<PrintService> d = new DefaultComboBoxModel<PrintService>(p);
        this.cmbImpressoras.setModel(d);
        if (printerName == null) {
            printerName = PrintServiceLookup.lookupDefaultPrintService().getName();
        }
        for (int i = 0; i < d.getSize(); ++i) {
            PrintService pf = d.getElementAt(i);
            if (pf == null || !pf.getName().equalsIgnoreCase(printerName)) continue;
            this.cmbImpressoras.setSelectedIndex(i);
            break;
        }
    }

    private void printParImpar(PrinterJob printJob, JasperPrint print) throws JRException, PrinterException {
        List pages = print.getPages();
        ArrayList parPages = new ArrayList();
        ArrayList imparPages = new ArrayList();
        for (int i = 1; i <= pages.size(); ++i) {
            if (i % 2 == 0) {
                parPages.add(pages.get(i - 1));
                continue;
            }
            imparPages.add(pages.get(i - 1));
        }
        pages.clear();
        pages.addAll(imparPages);
        Book book = new Book();
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        printJob.setJobName("JasperReports - " + print.getName());
        if (print.getOrientationValue().equals((Object)OrientationEnum.LANDSCAPE)) {
            pageFormat.setOrientation(0);
            paper.setSize(print.getPageHeight(), print.getPageWidth());
            paper.setImageableArea(0.0, 0.0, print.getPageHeight(), print.getPageWidth());
        } else {
            pageFormat.setOrientation(1);
            paper.setSize(print.getPageWidth(), print.getPageHeight());
            paper.setImageableArea(0.0, 0.0, print.getPageWidth(), print.getPageHeight());
        }
        pageFormat.setPaper(paper);
        ContatoJasperReportsJRPrinterAWT awt = new ContatoJasperReportsJRPrinterAWT(print);
        book.append((Printable)((Object)awt), pageFormat, print.getPages().size());
        printJob.setPageable(book);
        printJob.print();
        int op = ContatoDialogsHelper.showQuestion("Clique em Ok para imprimir as p\u00e1ginas pares.");
        if (op == 0) {
            pages.clear();
            pages.addAll(parPages);
            book = new Book();
            awt = new ContatoJasperReportsJRPrinterAWT(print);
            book.append((Printable)((Object)awt), pageFormat, print.getPages().size());
            printJob.setPageable(book);
            printJob.print();
        }
    }

    private void printAll(PrinterJob printJob, JasperPrint print) throws JRException, PrinterException {
        Book book = new Book();
        ContatoJasperReportsJRPrinterAWT awt = new ContatoJasperReportsJRPrinterAWT(print);
        PageFormat pageFormat = printJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        printJob.setJobName("JasperReports - " + print.getName());
        if (print.getOrientationValue().equals((Object)OrientationEnum.LANDSCAPE)) {
            pageFormat.setOrientation(0);
            paper.setSize(print.getPageHeight(), print.getPageWidth());
            paper.setImageableArea(0.0, 0.0, print.getPageHeight(), print.getPageWidth());
        } else {
            pageFormat.setOrientation(1);
            paper.setSize(print.getPageWidth(), print.getPageHeight());
            paper.setImageableArea(0.0, 0.0, print.getPageWidth(), print.getPageHeight());
        }
        pageFormat.setPaper(paper);
        book.append((Printable)((Object)awt), pageFormat, print.getPages().size());
        printJob.setPageable(book);
        printJob.print();
    }

    public ContatoButton getBtnImprimir() {
        return this.btnImprimir;
    }

    public void setBtnImprimir(ContatoButton btnImprimir) {
        this.btnImprimir = btnImprimir;
    }

    private void printAndDispose(JasperPrint print) {
        try {
            this.print(print);
            this.dispose();
        }
        catch (PrinterException ex) {
            ContatoDialogsHelper.showError("Erro ao imprimir. \n" + ex.getMessage());
            Logger.getLogger(InfoPrintDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JRException ex) {
            ContatoDialogsHelper.showError("Erro ao imprimir. \n" + ex.getMessage());
            Logger.getLogger(InfoPrintDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

