/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.swing.ContatoFormattedTextField;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class ContatoCodigoTextField
extends ContatoFormattedTextField {
    private Integer precisao = 3;
    private Integer grau = 3;

    public ContatoCodigoTextField() {
        this.initProperties();
        this.buildMascara(this.precisao, this.grau);
    }

    public void initField(Integer precisao, Integer grau) {
        this.precisao = precisao != null && precisao > 0 ? precisao : 3;
        this.grau = grau != null && grau > 0 ? grau : 3;
        this.buildMascara(precisao, grau);
        this.buildSize(precisao);
    }

    private void initProperties() {
        this.setHorizontalAlignment(0);
    }

    private void buildMascara(Integer precisao, Integer grau) {
        String maskString = this.getMaskString(precisao, grau);
        try {
            MaskFormatter formatter = null;
            formatter = new MaskFormatter(maskString);
            DefaultFormatterFactory factory = new DefaultFormatterFactory();
            factory.setDefaultFormatter(formatter);
            factory.setDisplayFormatter(formatter);
            factory.setEditFormatter(formatter);
            factory.setNullFormatter(formatter);
            this.setFormatterFactory(factory);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private String getMaskString(Integer precisao, Integer grau) {
        StringBuilder mask = new StringBuilder();
        for (int p = 0; p < precisao; ++p) {
            for (int g = 0; g < grau; ++g) {
                mask.append('#');
            }
            if (p >= precisao - 1) continue;
            mask.append(".");
        }
        return mask.toString();
    }

    private void buildSize(Integer precisao) {
        Dimension size = new Dimension(35 * precisao, 18);
        this.setSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
    }
}

