/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.components.DateTimePicker;
import com.github.lgooddatepicker.optionalusertools.DateChangeListener;
import com.github.lgooddatepicker.optionalusertools.DateHighlightPolicy;
import com.github.lgooddatepicker.zinternaltools.DateChangeEvent;
import com.github.lgooddatepicker.zinternaltools.HighlightInformation;
import com.touchcomp.basementortools.tools.date.TDate;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoComponent30x30Size;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.ColorFocus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ContatoDateTimeTextField
extends DateTimePicker
implements ContatoControllerComponent,
ContatoClearComponent,
ColorFocus,
ContatoComponent30x30Size {
    private int currentState;

    public ContatoDateTimeTextField() {
        this.setDateSettings();
        this.setFocusEventDate();
        this.setFocusEventTime();
        this.setKeyEventDate();
        this.setKeyEventTime();
        this.setReadWrite();
        this.setListenerOnDate();
        this.setActionListener();
        this.getComponentTimeTextField().setBackground(Color.white);
    }

    private void setActionListener() {
        this.getDatePicker().getComponentToggleCalendarButton().addActionListener(e -> this.getComponentDateTextField().requestFocus());
        this.getTimePicker().getComponentToggleTimeMenuButton().addActionListener(e -> this.getComponentTimeTextField().requestFocus());
    }

    private void setDateSettings() {
        DatePickerSettings dateSettings = new DatePickerSettings();
        dateSettings.setAllowKeyboardEditing(true);
        dateSettings.setAllowEmptyDates(true);
        dateSettings.setHighlightPolicy((DateHighlightPolicy)new SampleHighlightPolicy());
        dateSettings.setFormatForDatesCommonEra("dd/MM/yyyy");
        dateSettings.setColor(DatePickerSettings.DateArea.TextFieldBackgroundDisabled, Color.white);
        this.getDatePicker().setSettings(dateSettings);
    }

    private void setKeyEventDate() {
        this.getComponentDateTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ContatoDateTimeTextField.this.formatDateDinamically(ContatoDateTimeTextField.this.getComponentDateTextField(), e);
            }
        });
    }

    private void setKeyEventTime() {
        this.getComponentTimeTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ContatoDateTimeTextField.this.formatTimeDinamically(ContatoDateTimeTextField.this.getComponentTimeTextField(), e);
            }
        });
    }

    private void setFocusEventDate() {
        FocusListener[] focus;
        FocusAdapter fa = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ContatoDateTimeTextField.this.getComponentDateTextField().select(0, ContatoDateTimeTextField.this.getComponentDateTextField().getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
                ContatoDateTimeTextField.this.checkCompleteDate(ContatoDateTimeTextField.this.getComponentDateTextField());
            }
        };
        for (FocusListener focu : focus = this.getComponentDateTextField().getFocusListeners()) {
            this.getComponentDateTextField().removeFocusListener(focu);
        }
        this.getComponentDateTextField().addFocusListener(fa);
        for (FocusListener focu : focus) {
            this.getComponentDateTextField().addFocusListener(focu);
        }
    }

    private void setFocusEventTime() {
        FocusListener[] focus;
        FocusAdapter fa = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ContatoDateTimeTextField.this.getComponentTimeTextField().select(0, ContatoDateTimeTextField.this.getComponentTimeTextField().getText().length());
            }

            @Override
            public void focusLost(FocusEvent e) {
                ContatoDateTimeTextField.this.checkCompleteTime(ContatoDateTimeTextField.this.getComponentTimeTextField());
            }
        };
        for (FocusListener focu : focus = this.getComponentTimeTextField().getFocusListeners()) {
            this.getComponentTimeTextField().removeFocusListener(focu);
        }
        this.getComponentTimeTextField().addFocusListener(fa);
        for (FocusListener focu : focus) {
            this.getComponentTimeTextField().addFocusListener(focu);
        }
    }

    private void checkCompleteDate(JTextField componentDateTextField) {
        String text = componentDateTextField.getText();
        if (text == null || text.length() == 0) {
            return;
        }
        char[] dataValor = text.toCharArray();
        char[] dataCorrente = TDate.dateToStr((Date)new Date()).toCharArray();
        char[] arrayDate = new char[dataCorrente.length];
        for (int i = 0; i < arrayDate.length; ++i) {
            int ch1 = 32;
            if (i < dataValor.length) {
                ch1 = dataValor[i];
            }
            int ch2 = dataCorrente[i];
            arrayDate[i] = ch1 == 32 ? ch2 : ch1;
        }
        this.getComponentDateTextField().setText(new String(arrayDate));
    }

    private void checkCompleteTime(JTextField componentDateTextField) {
        String text = componentDateTextField.getText();
        if (text == null || text.length() == 0) {
            return;
        }
        char[] dataValor = text.toCharArray();
        char[] dataCorrente = TDate.dateToStr((Date)new Date(), (String)"HH:mm").toCharArray();
        char[] arrayDate = new char[dataCorrente.length];
        for (int i = 0; i < arrayDate.length; ++i) {
            int ch1 = 32;
            if (i < dataValor.length) {
                ch1 = dataValor[i];
            }
            int ch2 = dataCorrente[i];
            arrayDate[i] = ch1 == 32 ? ch2 : ch1;
        }
        this.getComponentTimeTextField().setText(new String(arrayDate));
    }

    private void formatDateDinamically(JTextField componentDateTextField, KeyEvent e) {
        if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
            return;
        }
        Object text = componentDateTextField.getText();
        if (text == null) {
            return;
        }
        if (((String)text).length() == 2) {
            text = (String)text + "/";
        }
        if (((String)text).length() == 5) {
            text = (String)text + "/";
        }
        if (((String)text).length() == 8 && !((String)text).contains("/")) {
            text = (String)text + new SimpleDateFormat("dd/MM/yyyy").format(text);
        }
        componentDateTextField.setText((String)text);
    }

    private void formatTimeDinamically(JTextField componentDateTextField, KeyEvent e) {
        if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
            return;
        }
        Object text = componentDateTextField.getText();
        if (text == null) {
            return;
        }
        if (((String)text).length() == 2) {
            text = (String)text + ":";
        }
        if (((String)text).length() == 4 && !((String)text).contains(":")) {
            text = (String)text + new SimpleDateFormat("HH:mm").format(text);
        }
        componentDateTextField.setText((String)text);
    }

    private void putClientProperty(int type) {
        this.putClientProperty("ACCESS", type);
    }

    public JTextField getComponentDateTextField() {
        return this.datePicker.getComponentDateTextField();
    }

    public JTextField getComponentTimeTextField() {
        return this.timePicker.getComponentTimeTextField();
    }

    public String getText() {
        if (this.getCurrentDate() == null) {
            return null;
        }
        return TDate.dateToStr((Date)this.getCurrentDate(), (String)"dd/MM/yyyy hh:mm:ss");
    }

    private void setListenerOnDate() {
        this.datePicker.addDateChangeListener(new DateChangeListener(){

            public void dateChanged(DateChangeEvent event) {
                if (ContatoDateTimeTextField.this.datePicker.getDate() != null && ContatoDateTimeTextField.this.timePicker.getText() == null || ContatoDateTimeTextField.this.timePicker.getText().isEmpty()) {
                    ContatoDateTimeTextField.this.timePicker.setText(TDate.dateToStr((Date)TDate.asDate((LocalDate)ContatoDateTimeTextField.this.datePicker.getDate()), (String)"HH:mm"));
                }
            }
        });
    }

    public void setEditable(boolean editable) {
        this.getComponentDateTextField().setEditable(editable);
        this.getComponentTimeTextField().setEditable(editable);
        this.getDatePicker().getComponentToggleCalendarButton().setEnabled(editable);
        this.getTimePicker().getComponentToggleTimeMenuButton().setEnabled(editable);
    }

    public static void main(String[] args) {
        JPanel j = new JPanel();
        j.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.gridx = 0;
        gb.gridy = 0;
        ContatoDateTimeTextField cd = new ContatoDateTimeTextField();
        j.add((Component)((Object)cd), gb);
        gb.gridx = 1;
        gb.gridy = 0;
        ContatoDateTimeTextField cd2 = new ContatoDateTimeTextField();
        j.add((Component)((Object)cd2), gb);
        JDialog d = new JDialog();
        d.setContentPane(j);
        d.setSize(300, 200);
        d.setLocationRelativeTo(null);
        d.setVisible(true);
    }

    public void setPreferredSize(Dimension preferredSize) {
        if (preferredSize.getHeight() < 25.0) {
            preferredSize.height = 25;
        }
        if (preferredSize.getWidth() < 180.0) {
            preferredSize.width = 190;
        }
        super.setPreferredSize(preferredSize);
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.getComponentDateTextField().addFocusListener(l);
        this.getComponentTimeTextField().addFocusListener(l);
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty(0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty(1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty(2);
    }

    @Override
    public void setDontController() {
        this.putClientProperty(-10);
    }

    @Override
    public void changeCollorFocusGained() {
    }

    @Override
    public void changeCollorFocusLost() {
    }

    public void setCurrentDate(Date value) {
        this.setDateTimeStrict(TDate.formatarLocalDateTime((Date)value));
    }

    public Date getCurrentDate() {
        return TDate.asDate((LocalDateTime)super.getDateTimeStrict());
    }

    private static class SampleHighlightPolicy
    implements DateHighlightPolicy {
        private SampleHighlightPolicy() {
        }

        public HighlightInformation getHighlightInformationOrNull(LocalDate date) {
            if (date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY) {
                return new HighlightInformation(Color.orange, Color.yellow, "It's Saturday!");
            }
            return null;
        }
    }
}

