/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import javax.swing.filechooser.FileFilter;

public class ContatoFileChooser
extends FileDialog {
    private FileFilter fileFilter;

    public ContatoFileChooser() {
        super((Frame)null);
    }

    public ContatoFileChooser(File currentDirectory) {
        this();
        if (currentDirectory != null) {
            this.setFile(currentDirectory.getAbsolutePath());
        }
    }

    public ContatoFileChooser(String currentDirectory) {
        this();
        this.setFile(currentDirectory);
    }

    public File getSelectedFile() {
        if (this.getFile() != null) {
            return this.filter(new File(this.getFile()));
        }
        return null;
    }

    public File[] getSelectedFiles() {
        return this.filter(super.getFiles());
    }

    @Override
    public String getDirectory() {
        return super.getDirectory();
    }

    public File getDirectoryFile() {
        if (super.getDirectory() != null) {
            File f = new File(super.getDirectory());
            return f.isDirectory() ? f : f.getParentFile();
        }
        return null;
    }

    public void setFileFilter(final FileFilter filter) {
        this.fileFilter = filter;
        this.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (filter == null) {
                    return true;
                }
                return filter.accept(new File(dir.getAbsolutePath() + File.separator + name));
            }
        });
    }

    @Override
    public void setFile(String file) {
        super.setFile(file);
    }

    @Override
    public String getFile() {
        File ret = null;
        if (super.getFile() != null) {
            ret = new File(this.getDirectory() + super.getFile());
            ret = this.filter(ret);
        }
        return ret != null ? ret.getAbsolutePath() : null;
    }

    @Override
    public void setDirectory(String dir) {
        super.setDirectory(dir);
    }

    public void setDirectory(File dir) {
        if (!dir.isDirectory()) {
            dir = dir.getParentFile();
        }
        super.setDirectory(dir.getAbsolutePath());
    }

    private File filter(File file) {
        if (this.fileFilter == null) {
            return file;
        }
        if (this.fileFilter.accept(file)) {
            return file;
        }
        return null;
    }

    private File[] filter(File[] file) {
        LinkedList<File> l = new LinkedList<File>();
        for (File file1 : file) {
            if (this.filter(file1) == null) continue;
            l.add(file1);
        }
        return l.toArray(new File[0]);
    }
}

