/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoMaskFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoPeriodTextField
extends ContatoFormattedTextField {
    public ContatoPeriodTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getMaskPeriod());
        this.setHorizontalAlignment(0);
    }

    public Date getInitialDate() {
        if (this.getPeriod() != null) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime(this.getPeriod());
            g.set(5, 1);
            return g.getTime();
        }
        return null;
    }

    public Date getFinalDate() {
        if (this.getPeriod() != null) {
            GregorianCalendar g = new GregorianCalendar();
            g.setTime(this.getPeriod());
            g.set(5, g.getActualMaximum(5));
            g.set(11, g.getActualMaximum(11));
            g.set(12, g.getActualMaximum(12));
            g.set(13, g.getActualMaximum(13));
            g.set(14, g.getActualMaximum(14));
            return g.getTime();
        }
        return null;
    }

    public Date getPeriod() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoPeriodTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null) {
            try {
                value = ContatoDateUtil.strToDate((String)((String)value), (String)"MM/yyyy");
                return (Date)value;
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
        }
        return null;
    }

    public void setPeriod(Date data) {
        this.setValue(data);
    }

    @Override
    public void setValue(Object value) {
        String newValue = null;
        try {
            if (value != null) {
                if (value instanceof String) {
                    value = ContatoDateUtil.strToDate((String)((String)value), (String)"MM/yyyy");
                }
                if (!(value instanceof Date)) {
                    throw new ContatoInvalidValueException("Invalid value: " + String.valueOf(value.getClass()) + " expected: java.util.Date");
                }
                newValue = ContatoDateUtil.dateToStr((Date)((Date)value), (String)"MM/yyyy");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.setValue(newValue);
    }

    @Override
    public void commitEdit() throws ParseException {
        block7: {
            String newValue = super.getText().trim();
            try {
                if (newValue != null && newValue.length() == 7) {
                    try {
                        ContatoDateUtil.strToDate((String)newValue, (String)"MM/yyyy");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ParseException("Data inv\u00e1lida!", 5);
                    }
                    try {
                        super.commitEdit();
                        break block7;
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                        throw new ParseException("Data Inv\u00e1lida!", 5);
                    }
                }
                super.setValue(null);
            }
            catch (ParseException ex) {
                super.setValue(null);
                this.requestFocus();
            }
        }
    }
}

