/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.dialog.ContatoDialogsHelper;
import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoCepTextField;
import contato.swing.ContatoFormattedTextField;
import contatocore.util.ContatoFormatterUtil;
import contatocore.util.ContatoMaskFactory;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.geom.RoundRectangle2D;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoRoundedDoubleTextField
extends ContatoFormattedTextField {
    private boolean verifyValor = true;
    private Shape shape;

    public ContatoRoundedDoubleTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getDefaultDoubleFormatter());
        this.setValue(0.0);
        this.setHorizontalAlignment(4);
    }

    public ContatoRoundedDoubleTextField(int decimalSize) {
        this.setFormatterFactory(ContatoFormatterUtil.getDoubleFormatterDecimalSize((int)decimalSize));
        this.setValue(null);
        this.setHorizontalAlignment(4);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            this.selectAll();
        } else if (e.getID() == 1005) {
            try {
                this.commitEdit();
                if (this.isVerifyValor() && this.getDouble() < 0.0) {
                    ContatoDialogsHelper.showError("Valor inv\u00e1lido!");
                    this.setDouble(0.0);
                }
            }
            catch (ParseException ex) {
                this.setValue(0.0);
            }
        }
    }

    public Double getDouble() {
        try {
            if (this.getValue() == null) {
                this.setValue(0.0);
            }
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCepTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        return (Double)this.getValue();
    }

    public void setDouble(Double value) {
        this.setValue(value);
    }

    @Override
    public void clear() {
        this.setValue(0.0);
    }

    @Override
    public void setValue(Object value) {
        Double newValue = null;
        if (value != null) {
            try {
                if (!(value instanceof Double)) {
                    throw new ContatoInvalidValueException("Invalid value: " + String.valueOf(value.getClass()) + " expected: java.util.Double");
                }
                newValue = (Double)value;
            }
            catch (ContatoInvalidValueException ex) {
                ex.printStackTrace();
            }
        }
        super.setValue(newValue);
    }

    public boolean isVerifyValor() {
        return this.verifyValor;
    }

    public void setVerifyValor(boolean verifyValor) {
        this.verifyValor = verifyValor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        g.setColor(this.getForeground());
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 10.0f, 10.0f);
        }
        return this.shape.contains(x, y);
    }
}

