/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoCPFTextField;
import contato.swing.ContatoMaskTextField;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoMaskFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContatoTableDateTimeTextField
extends ContatoMaskTextField {
    public ContatoTableDateTimeTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getMaskDateTime());
        this.setHorizontalAlignment(0);
    }

    @Override
    public void setValue(Object value) {
        String newValue = null;
        try {
            if (value != null) {
                if (!(value instanceof Date)) {
                    throw new ContatoInvalidValueException("Invalid value: " + String.valueOf(value.getClass()) + " expected: java.util.Date");
                }
                newValue = ContatoDateUtil.dateToStr((Date)((Date)value), (String)"dd/MM/yyyy-HH:mm");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.setValue(newValue);
    }

    @Override
    public void commitEdit() throws ParseException {
        block7: {
            String newValue = super.getText().trim();
            try {
                if (newValue != null && newValue.length() == 16) {
                    try {
                        ContatoDateUtil.strToDate((String)newValue, (String)"dd/MM/yyyy-HH:mm");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ParseException("Data inv\u00e1lida!", 5);
                    }
                    try {
                        super.commitEdit();
                        break block7;
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                        throw new ParseException("Data Inv\u00e1lida!", 5);
                    }
                }
                super.setValue(null);
            }
            catch (ParseException ex) {
                super.setValue(null);
                this.requestFocus();
            }
        }
    }

    public Date getDate() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null) {
            try {
                value = ContatoDateUtil.strToDate((String)((String)value), (String)"dd/MM/yyyy-HH:mm");
                return (Date)value;
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
        }
        return null;
    }

    @Override
    public String getToolTipText() {
        Object text = null;
        if (super.getToolTipText() != null) {
            text = "";
            text = (String)text + "<html><b>" + super.getToolTipText();
            text = (String)text + "</b>" + (String)(this.getValue() != null && this.getValue().toString().trim().length() > 0 ? "<br>" + String.valueOf(this.getValue()) : "");
            text = (String)text + "</html>";
        }
        return text;
    }

    public void setDate(Date data) {
        this.setValue(data);
    }
}

