/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.constants.ContatoConstants;
import contato.controller.ContatoFixedLengthDocument;
import contato.interfaces.ContatoClearComponent;
import contato.interfaces.ContatoControllerComponent;
import contato.swing.dictionary.JTextCompSpellChecker;
import contato.swing.textutilities.ContatoSwingTextUtilities;
import contato.util.ContatoTextUtilities;
import contato.util.FindAndReplace;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.FocusEvent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.dts.spell.swing.utils.ErrorPopUpMenu;

public class ContatoTextArea
extends JTextArea
implements ContatoControllerComponent,
ContatoClearComponent {
    private FindAndReplace findAndReplace;
    private JFrame frame;

    public ContatoTextArea() {
        this.setReadWrite();
        ContatoTextUtilities.initBasicPopupTextMenu(this);
        ContatoSwingTextUtilities.initRedoAndUndo(this);
    }

    public ContatoTextArea(Document doc) {
        super(doc);
        this.setReadWrite();
        ContatoSwingTextUtilities.initRedoAndUndo(this);
    }

    public ContatoTextArea(String text) {
        super(text);
        this.setReadWrite();
        ContatoSwingTextUtilities.initRedoAndUndo(this);
    }

    public ContatoTextArea(int rows, int columns) {
        super(rows, columns);
        this.setReadWrite();
        ContatoSwingTextUtilities.initRedoAndUndo(this);
    }

    public ContatoTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.setReadWrite();
        ContatoSwingTextUtilities.initRedoAndUndo(this);
    }

    public ContatoTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        this.setReadWrite();
        ContatoSwingTextUtilities.initRedoAndUndo(this);
    }

    public void setFixedSize(int size) {
        this.setDocument(new ContatoFixedLengthDocument(size));
    }

    @Override
    public void setReadOnly() {
        this.putClientProperty("ACCESS", 0);
    }

    @Override
    public void setReadWrite() {
        this.putClientProperty("ACCESS", 1);
    }

    @Override
    public void setReadWriteDontUpdate() {
        this.putClientProperty("ACCESS", 2);
    }

    @Override
    public void clear() {
        this.setText(ContatoConstants.EMPTY);
    }

    @Override
    public String getToolTipText() {
        Object text = null;
        if (super.getToolTipText() != null) {
            text = "";
            text = (String)text + "<html><b>" + super.getToolTipText();
            text = (String)text + "</b>";
            text = (String)text + "</html>";
        }
        return text;
    }

    @Override
    public void setDontController() {
        this.putClientProperty("ACCESS", -10);
    }

    private Frame getFrame() {
        if (this.frame == null) {
            for (Container comp = this.getParent(); comp != null; comp = comp.getParent()) {
                if (!(comp instanceof JFrame)) continue;
                this.frame = (JFrame)comp;
                break;
            }
        }
        return this.frame;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            JTextCompSpellChecker.getInstance().startSpellCheck(this);
            ErrorPopUpMenu.cleanErrorPopupMenu((JPopupMenu)this.getComponentPopupMenu());
        } else if (e.getID() == 1005) {
            JTextCompSpellChecker.getInstance().stopSpellCheck(this);
        }
        super.processFocusEvent(e);
    }

    @Override
    public String getText() {
        String txt;
        Document doc = this.getDocument();
        try {
            txt = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            txt = null;
        }
        return txt;
    }

    public void setColuns(int numColuns) {
        this.setDocument(new ContatoFixedLengthDocument(numColuns));
    }
}

