/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.controller.ContatoFixedLengthDocument;
import contato.swing.ContatoTextPane;
import contato.swing.dictionary.JTextCompSpellChecker;
import contato.swing.textutilities.ContatoSwingTextUtilities;
import contato.util.FindAndReplace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.dts.spell.swing.utils.ErrorPopUpMenu;

public class ContatoTextComponent
extends ContatoTextPane {
    private Frame frame = null;
    private FindAndReplace findAndReplace;

    public ContatoTextComponent() {
        this.initRedoAndUndo();
        this.setReadWrite();
        ContatoSwingTextUtilities.initRedoAndUndo(this);
    }

    public ContatoTextComponent(Frame frame) {
        this();
        this.frame = frame;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            JTextCompSpellChecker.getInstance().startSpellCheck(this);
            ErrorPopUpMenu.cleanErrorPopupMenu((JPopupMenu)this.getComponentPopupMenu());
        } else if (e.getID() == 1005) {
            JTextCompSpellChecker.getInstance().stopSpellCheck(this);
        }
        super.processFocusEvent(e);
    }

    private void initRedoAndUndo() {
        final UndoManager undo = new UndoManager();
        Document doc = this.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction(this, "Undo"){
            final /* synthetic */ ContatoTextComponent this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction(this, "Redo"){
            final /* synthetic */ ContatoTextComponent this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getActionMap().put("Find", new AbstractAction("Find"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContatoTextComponent.this.getFindAndReplace().requestFocus();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.getInputMap().put(KeyStroke.getKeyStroke("control F"), "Find");
    }

    public FindAndReplace getFindAndReplace() {
        if (this.findAndReplace == null) {
            this.findAndReplace = new FindAndReplace(this.getFrame(), this.getInstance());
            this.findAndReplace.getTxtProcurar().requestFocus();
            this.findAndReplace.setLocationRelativeTo(this.getInstance());
            this.findAndReplace.setVisible(true);
        }
        return this.findAndReplace;
    }

    public void getTextInternal(Element e) {
        e.getName();
    }

    public ContatoTextComponent getInstance() {
        return this;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setFindAndReplace(FindAndReplace findAndReplace) {
        this.findAndReplace = findAndReplace;
    }

    public void setRows(int rows) {
    }

    public void append(String str) {
        try {
            this.getDocument().insertString(this.getDocument().getLength() - 1, str, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ContatoTextComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setColumns(int columns) {
        this.setDocument(new ContatoFixedLengthDocument(columns));
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
    }

    public void setFixedSize(int size) {
        this.setDocument(new ContatoFixedLengthDocument(size));
    }

    public void insert(String str, int beginIndex) {
        try {
            this.getDocument().insertString(beginIndex, str, null);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(ContatoTextComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String getText() {
        String txt;
        Document doc = this.getDocument();
        try {
            txt = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            txt = null;
        }
        txt = txt.trim().replaceAll(" +", " ");
        return txt;
    }
}

