/*
 * Decompiled with CFR 0.152.
 */
package contato.swing;

import contato.exception.ContatoInvalidValueException;
import contato.swing.ContatoCPFTextField;
import contato.swing.ContatoMaskTextField;
import contatocore.util.ContatoDateUtil;
import contatocore.util.ContatoMaskFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.DefaultFormatterFactory;

public class ContatoTimeTextField
extends ContatoMaskTextField {
    private Date original;
    String maskPattern;

    public ContatoTimeTextField() {
        this.setFormatterFactory(ContatoMaskFactory.getMaskTime());
        this.setHorizontalAlignment(0);
        this.maskPattern = "HH:mm:ss";
    }

    public ContatoTimeTextField(DefaultFormatterFactory mask, String maskPattern) {
        this.setFormatterFactory(mask);
        this.maskPattern = maskPattern;
        this.setHorizontalAlignment(0);
    }

    @Override
    public void setValue(Object value) {
        String newValue = null;
        try {
            if (value != null) {
                if (!(value instanceof Date)) {
                    throw new ContatoInvalidValueException("Invalid value: " + String.valueOf(value.getClass()) + " expected: java.util.Date");
                }
                newValue = ContatoDateUtil.dateToStr((Date)((Date)value), (String)this.maskPattern);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.setValue(newValue);
    }

    @Override
    public void commitEdit() throws ParseException {
        block7: {
            String newValue = super.getText().trim();
            try {
                if (newValue != null && newValue.length() == this.maskPattern.length()) {
                    try {
                        ContatoDateUtil.strToDate((String)newValue, (String)this.maskPattern);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new ParseException("Data inv\u00e1lida!", 5);
                    }
                    try {
                        super.commitEdit();
                        break block7;
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                        throw new ParseException("Data Inv\u00e1lida!", 5);
                    }
                }
                super.setValue(null);
            }
            catch (ParseException ex) {
                super.setValue(null);
                this.requestFocus();
            }
        }
    }

    public Date getDate() {
        try {
            this.commitEdit();
        }
        catch (ParseException ex) {
            Logger.getLogger(ContatoCPFTextField.class.getName()).log(Level.SEVERE, null, ex);
        }
        Object value = super.getValue();
        if (value != null) {
            try {
                value = ContatoDateUtil.strToDate((String)((String)value), (String)this.maskPattern);
                if (this.original != null && value != null) {
                    GregorianCalendar g = new GregorianCalendar();
                    g.setTime(this.original);
                    GregorianCalendar g1 = new GregorianCalendar();
                    g1.setTime((Date)value);
                    g.set(11, g1.get(11));
                    g.set(12, g1.get(12));
                    g.set(13, g1.get(13));
                    g.set(14, g1.get(14));
                    value = g.getTime();
                }
                return (Date)value;
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
        }
        return null;
    }

    public Date getCurrentDate() {
        return this.getDate();
    }

    public void setCurrentDate(Date data) {
        this.setDate(data);
    }

    @Override
    public String getToolTipText() {
        Object text = null;
        if (super.getToolTipText() != null) {
            text = "";
            text = (String)text + "<html><b>" + super.getToolTipText();
            text = (String)text + "</b>" + (String)(this.getValue() != null && this.getValue().toString().trim().length() > 0 ? "<br>" + String.valueOf(this.getValue()) : "");
            text = (String)text + "</html>";
        }
        return text;
    }

    public void setDate(Date data) {
        this.setValue(data);
        this.original = data;
    }
}

