/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.table.model;

import contato.swing.table.column.ContatoTableColumn;
import contato.swing.table.model.ContatoTableColumnModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableModel;

public abstract class ContatoTableModel
extends DefaultTableModel {
    private ContatoTableColumnModel columnModel;
    private List objects = null;
    private boolean readOnly = false;
    private HashMap attributes = new HashMap();

    public List getObjects() {
        return this.objects;
    }

    public ContatoTableModel(List objects) {
        if (objects != null) {
            this.setObjects(objects);
        } else {
            this.setObjects(new ArrayList());
        }
    }

    public ContatoTableModel(List objects, ContatoTableColumnModel columnModel) {
        this.columnModel = columnModel;
        this.objects = objects != null ? objects : new ArrayList();
    }

    @Override
    public int getRowCount() {
        return this.getObjects() != null ? this.getObjects().size() : 0;
    }

    public String getToolTipText(int row, int column) {
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.columnModel != null) {
            ContatoTableColumn column = (ContatoTableColumn)this.columnModel.getColumn(columnIndex);
            return column.isIsEditable();
        }
        return !this.readOnly;
    }

    public void addRow(Object o) {
        if (this.getObjects() == null) {
            this.setObjects(new ArrayList());
        }
        this.getObjects().add(o);
        this.fireTableDataChanged();
    }

    public void addRows(List newObjects) {
        if (newObjects != null) {
            this.addRows(newObjects, false);
        }
    }

    public Object getObject(int row) {
        return this.getObjects() != null && !this.getObjects().isEmpty() ? this.getObjects().get(row) : null;
    }

    public void addRows(List objects, boolean append) {
        if (objects != null) {
            if (append) {
                this.getObjects().addAll(objects);
            } else {
                this.setObjects(objects);
            }
        }
        this.fireTableDataChanged();
    }

    public void delete(int row) {
        this.getObjects().remove(row);
        this.fireTableRowsDeleted(row, row);
        this.fireTableDataChanged();
    }

    public void delete(Object obj) {
        int index = this.getObjects().indexOf(obj);
        if (index > -1) {
            this.getObjects().remove(obj);
            this.fireTableRowsDeleted(index, index);
            this.fireTableDataChanged();
        }
    }

    public void clear() {
        this.setObjects(new ArrayList());
        this.fireTableDataChanged();
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean aValue) {
        this.readOnly = aValue;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.columnModel != null) {
            return this.getColumnValue(rowIndex, columnIndex);
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return super.getColumnClass(columnIndex);
    }

    private Object getColumnValue(int rowIndex, int columnIndex) {
        try {
            Object obj = this.getObject(rowIndex);
            ContatoTableColumn column = (ContatoTableColumn)this.columnModel.getColumn(columnIndex);
            return obj.getClass().getField(column.getAttributeName()).get(obj);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(ContatoTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(ContatoTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(ContatoTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ContatoTableModel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return super.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.columnModel != null) {
            this.setColumnValue(aValue, rowIndex, columnIndex);
        }
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    private void setColumnValue(Object aValue, int row, int columnIndex) {
        try {
            Object obj = this.getObject(row);
            ContatoTableColumn column = (ContatoTableColumn)this.columnModel.getColumn(columnIndex);
            obj.getClass().getField(column.getAttributeName()).set(obj, obj);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(ContatoTableModel.class.getName()).log(Level.SEVERE, null, ex);
            super.setValueAt(aValue, row, columnIndex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(ContatoTableModel.class.getName()).log(Level.SEVERE, null, ex);
            super.setValueAt(aValue, row, columnIndex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(ContatoTableModel.class.getName()).log(Level.SEVERE, null, ex);
            super.setValueAt(aValue, row, columnIndex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ContatoTableModel.class.getName()).log(Level.SEVERE, null, ex);
            super.setValueAt(aValue, row, columnIndex);
        }
    }

    public void setObjects(List objects) {
        this.objects = objects;
    }

    public boolean dragAndDropCell(JTable target, TransferHandler.TransferSupport info, Integer rowToDrag, Integer columnToDrag, int rowToDrop, int columnToDrop) {
        return false;
    }

    public void setTableAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getTableAttribute(String key) {
        return this.attributes.get(key);
    }
}

