/*
 * Decompiled with CFR 0.152.
 */
package contato.swing.table.renderer;

import contato.swing.table.edit.ContatoTableCellEditor;
import contato.swing.table.model.ContatoTableModel;
import contato.swing.table.renderer.ContatoIntegerRenderer;
import contato.swing.table.renderer.ContatoTableCellRenderer;
import contatocore.util.ContatoDateUtil;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class ContatoTimeRenderer
extends ContatoTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ContatoTableCellEditor editor = (ContatoTableCellEditor)table.getColumnModel().getColumn(column).getCellEditor();
        if (editor == null) {
            editor = (ContatoTableCellEditor)table.getDefaultEditor(Date.class);
        }
        JTextComponent text = (JTextComponent)editor.getComponente();
        TableColumn coluna = table.getColumnModel().getColumn(column);
        editor.setSaveTextField(text);
        try {
            if (value != null) {
                if (value instanceof Timestamp) {
                    Timestamp valueTimeStamp = (Timestamp)value;
                    label.setText(ContatoDateUtil.dateToStr((Date)valueTimeStamp, (String)"HH:mm"));
                } else if (value instanceof Date) {
                    Date valueTimeData = (Date)value;
                    label.setText(ContatoDateUtil.dateToStr((Date)valueTimeData, (String)"HH:mm"));
                } else if (value instanceof String) {
                    label.setText((String)value);
                }
            } else {
                label.setText("  :  ");
            }
        }
        catch (Exception ex) {
            label.setText(text.getText());
            Logger.getLogger(ContatoIntegerRenderer.class.getName()).log(Level.SEVERE, null, ex);
        }
        String toolTip = null;
        if (table.getModel() instanceof ContatoTableModel) {
            ContatoTableModel model = (ContatoTableModel)table.getModel();
            toolTip = model.getToolTipText(row, column);
        }
        if (toolTip == null) {
            toolTip = label.getText();
        }
        this.setToolTipText("<html><b>" + String.valueOf(coluna.getHeaderValue()) + "</b><br>" + toolTip + "</html>");
        label.setHorizontalAlignment(0);
        return label;
    }
}

