/*
 * Decompiled with CFR 0.152.
 */
package contato.util;

import com.touchcomp.basementorai.openai.AIOpenaAIBuilder;
import contato.dialog.ContatoDialogsHelper;
import contato.interfaces.ContatoSpellCheker;
import contato.swing.ContatoPanelAI;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class ContatoTextUtilities {
    public static JPopupMenu initBasicPopupTextMenu(JTextComponent textArea, boolean showAi) {
        JPopupMenu popUpMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(ContatoTextUtilities.findAction(textArea, "copy-to-clipboard"));
        item.setText("Copiar");
        popUpMenu.add(item);
        item = new JMenuItem();
        item.setText("Copiar Tudo");
        item.addActionListener(new ActionCopyAll(textArea));
        popUpMenu.add(item);
        item = new JMenuItem(ContatoTextUtilities.findAction(textArea, "cut-to-clipboard"));
        item.setText("Recortar");
        popUpMenu.add(item);
        item = new JMenuItem(ContatoTextUtilities.findAction(textArea, "paste-from-clipboard"));
        item.setText("Colar");
        popUpMenu.add(item);
        item = new JMenuItem(ContatoTextUtilities.findAction(textArea, "select-all"));
        item.setText("Selecionar tudo");
        popUpMenu.add(item);
        if (showAi) {
            item = new JMenuItem();
            item.setText("Usar Inteligencia Artificial");
            item.addActionListener(ContatoTextUtilities.findAiAction(textArea));
            popUpMenu.add(item);
        }
        if (textArea instanceof ContatoSpellCheker) {
            // empty if block
        }
        popUpMenu.setFocusable(false);
        textArea.setComponentPopupMenu(popUpMenu);
        return popUpMenu;
    }

    public static JPopupMenu initBasicPopupTextMenu(JTextComponent textArea) {
        return ContatoTextUtilities.initBasicPopupTextMenu(textArea, true);
    }

    private static ActionListener findAiAction(JTextComponent aux) {
        return e -> {
            if (!AIOpenaAIBuilder.get().isConfigured()) {
                ContatoDialogsHelper.showInfo("Primeiro, \u00e9 necess\u00e1rio configurar os dados de acesso da Inteligencia Artificial. Se j\u00e1 configurou, saia e entre novamente no sistema.");
                return;
            }
            ContatoPanelAI.openDialog(aux);
        };
    }

    private static Action findAction(JTextComponent textArea, String name) {
        Action[] actions = textArea.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i].getValue("Name") != name) continue;
            KeyStroke[] accelerator = textArea.getKeymap().getKeyStrokesForAction(actions[i]);
            if (null != accelerator && accelerator.length > 0) {
                actions[i].putValue("AcceleratorKey", accelerator[0]);
            }
            return actions[i];
        }
        return null;
    }

    static class ActionCopyAll
    implements ActionListener {
        private JTextComponent component;

        public ActionCopyAll(JTextComponent component) {
            this.component = component;
        }

        @Override
        public void actionPerformed(ActionEvent ie) {
            String text = this.component.getText();
            StringSelection stringSelection = new StringSelection(text);
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
        }
    }

    private static class SpellActionMarkErrors
    implements ActionListener {
        ContatoSpellCheker checker;

        public SpellActionMarkErrors(ContatoSpellCheker checker) {
            this.checker = checker;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.checker.getSpellCheck().markErrors((JTextComponent)((Object)this.checker));
        }
    }

    private static class SpellAction
    implements ActionListener {
        ContatoSpellCheker checker;

        public SpellAction(ContatoSpellCheker checker) {
            this.checker = checker;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.checker.getSpellCheck().spellCheck((JTextComponent)((Object)this.checker));
        }
    }
}

