/*
 * Decompiled with CFR 0.152.
 */
package contato.util.contatofilechooser;

import contato.dialog.ContatoDialogsHelper;
import contato.util.contatofilechooser.InfoImageSizeQuestion;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferByte;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class ComponentHouseResizer {
    private int width;
    private int heigth;
    private int MAX_RECOMENDED_HEIGTH = 600;
    private int MAX_RECOMENDED_WITH = 800;

    public static ComponentHouseResizer getInstance() {
        return new ComponentHouseResizer();
    }

    public static byte[] getBytesOfImage(String path) throws FileNotFoundException, IOException {
        FileInputStream inputStream = new FileInputStream(new File(path));
        byte[] byteArray = new byte[inputStream.available()];
        inputStream.read(byteArray);
        inputStream.close();
        return byteArray;
    }

    public byte[] processImage(String path, boolean showQuestion) throws IOException {
        BufferedImage image = ImageIO.read(new File(path));
        this.width = image.getWidth();
        this.heigth = image.getHeight();
        byte[] byteArray = null;
        if (this.continueProcess()) {
            image = ComponentHouseResizer.resize(image, this.width, this.heigth);
            File f = File.createTempFile(String.valueOf(new Date().getTime()), "png");
            ImageIO.write((RenderedImage)image, "png", f);
            byteArray = ComponentHouseResizer.getBytesOfImage(f.getAbsolutePath());
            f.delete();
        } else {
            byteArray = ComponentHouseResizer.getBytesOfImage(path);
        }
        return byteArray;
    }

    public static byte[] processImage(byte[] dados, int width, int height) throws IOException {
        ByteArrayInputStream b = new ByteArrayInputStream(dados);
        BufferedImage image = ComponentHouseResizer.resize(ImageIO.read(b), 24, 24);
        byte[] a = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        return a;
    }

    private static BufferedImage resize(BufferedImage image, int width, int height) {
        int type = image.getType() == 0 ? 2 : image.getType();
        BufferedImage resizedImage = new BufferedImage(width, height, 5);
        Graphics2D g = resizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    public static BufferedImage blurImage(BufferedImage image) {
        float ninth = 0.11111111f;
        float[] blurKernel = new float[]{ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth};
        HashMap<RenderingHints.Key, Object> map = new HashMap<RenderingHints.Key, Object>();
        map.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        map.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RenderingHints hints = new RenderingHints(map);
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, blurKernel), 1, hints);
        return op.filter(image, null);
    }

    private boolean continueProcess() {
        int result;
        if ((this.width > this.MAX_RECOMENDED_WITH || this.heigth > this.MAX_RECOMENDED_HEIGTH) && (result = ContatoDialogsHelper.showQuestion("A imagem selecionada possui um tamanho maior que o recomend\u00e1vel. Isto pode causar lentid\u00e3o ao computador. Deseja diminu\u00ed-la?")) == 0) {
            InfoImageSizeQuestion in = new InfoImageSizeQuestion(null, true, this.MAX_RECOMENDED_WITH, this.MAX_RECOMENDED_HEIGTH);
            in.setLocationRelativeTo(null);
            in.setVisible(true);
            this.width = in.getResultWidth();
            this.heigth = in.getResultHeigth();
            return true;
        }
        return false;
    }
}

