/*
 * Decompiled with CFR 0.152.
 */
package contato.util.contatofilechooser;

import contato.swing.ContatoFileChooser;
import contato.swing.ContatoImageFileChooser;
import contato.util.contatofilechooser.ComponentHouseResizer;
import contato.util.properties.PreferencesProperties;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ContatoFileChooserUtilities {
    public static byte[] getImageFromFile(boolean processImage, String currentDir) throws IOException {
        ContatoImageFileChooser fileChooser = new ContatoImageFileChooser();
        fileChooser.setMode(0);
        if (currentDir == null) {
            String lastDir = PreferencesProperties.getInstance().getLastDir();
            if (lastDir != null) {
                fileChooser.setDirectory(lastDir);
            }
        } else {
            fileChooser.setDirectory(currentDir);
        }
        fileChooser.setLocationRelativeTo(null);
        fileChooser.setSize(ContatoFileChooserUtilities.getSize());
        fileChooser.setVisible(true);
        File f = fileChooser.getSelectedFile();
        if (f != null && f.exists()) {
            PreferencesProperties.getInstance().setLastDir(f.getParent());
            if (processImage) {
                return ComponentHouseResizer.getInstance().processImage(f.getAbsolutePath(), true);
            }
            return ContatoFileChooserUtilities.getBytesOfFile(f.getAbsolutePath());
        }
        return null;
    }

    public static File getFileToLoad() {
        return ContatoFileChooserUtilities.getFileToLoad(null);
    }

    public static File getFileToLoad(FileFilter filter) {
        ContatoFileChooser fileChooser = new ContatoFileChooser();
        fileChooser.setMode(0);
        String lastDir = PreferencesProperties.getInstance().getLastDir();
        if (lastDir != null) {
            File last = new File(lastDir);
            fileChooser.setDirectory(last.getAbsolutePath());
        }
        fileChooser.setFileFilter(filter);
        fileChooser.setLocationRelativeTo(null);
        fileChooser.setSize(ContatoFileChooserUtilities.getSize());
        fileChooser.setVisible(true);
        String str = fileChooser.getFile();
        if (str == null) {
            return null;
        }
        File f = new File(str);
        PreferencesProperties.getInstance().setLastDir(f.getParent());
        return f;
    }

    public static List getFiles() {
        return ContatoFileChooserUtilities.getFiles(null);
    }

    public static List getFiles(FileFilter filter) {
        ContatoFileChooser fileChooser = new ContatoFileChooser();
        String lastDir = PreferencesProperties.getInstance().getLastDir();
        if (lastDir != null) {
            fileChooser.setDirectory(lastDir);
        }
        fileChooser.setMultipleMode(true);
        fileChooser.setFileFilter(filter);
        fileChooser.setSize(ContatoFileChooserUtilities.getSize());
        fileChooser.setPreferredSize(ContatoFileChooserUtilities.getSize());
        fileChooser.setLocationRelativeTo(null);
        fileChooser.setVisible(true);
        File[] f = fileChooser.getSelectedFiles();
        if (f != null && f.length > 0) {
            File f1 = f[0];
            PreferencesProperties.getInstance().setLastDir(f1.getParent());
            if (f1.exists()) {
                PreferencesProperties.getInstance().setLastDir(f1.getParent());
            }
        }
        return Arrays.asList(f);
    }

    public static File getImageFile() throws IOException {
        ContatoImageFileChooser fileChooser = new ContatoImageFileChooser();
        fileChooser.setMode(0);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("PNG") || f.getName().toUpperCase().endsWith("JPG") || f.getName().toUpperCase().endsWith("JPEG");
            }

            @Override
            public String getDescription() {
                return "Somente imagens";
            }
        });
        String lastDir = PreferencesProperties.getInstance().getLastDir();
        if (lastDir != null) {
            fileChooser.setFile(lastDir);
        }
        fileChooser.setSize(ContatoFileChooserUtilities.getSize());
        fileChooser.setLocationRelativeTo(null);
        fileChooser.setVisible(true);
        File f = fileChooser.getSelectedFile();
        if (f.exists()) {
            PreferencesProperties.getInstance().setLastDir(f.getParent());
            return f;
        }
        return f;
    }

    public static byte[] getBytesOfFile(String path) throws FileNotFoundException, IOException {
        FileInputStream inputStream = new FileInputStream(new File(path));
        byte[] byteArray = new byte[inputStream.available()];
        inputStream.read(byteArray);
        inputStream.close();
        return byteArray;
    }

    public static File getDirectoryAndFileToSave(String fileName) {
        ContatoFileChooser fileChooser = new ContatoFileChooser();
        fileChooser.setMode(1);
        String lastDir = PreferencesProperties.getInstance().getLastDir();
        if (lastDir != null) {
            fileChooser.setDirectory(lastDir);
        }
        fileChooser.setFile(fileName);
        fileChooser.setSize(ContatoFileChooserUtilities.getSize());
        fileChooser.setLocationRelativeTo(null);
        fileChooser.setVisible(true);
        String str = fileChooser.getFile();
        if (str == null) {
            return null;
        }
        File f = new File(str);
        if (f.exists()) {
            PreferencesProperties.getInstance().setLastDir(f.getAbsolutePath());
            return f;
        }
        return f;
    }

    private static Dimension getSize() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(screenSize.width, screenSize.height - 50);
    }

    public static File getDirectoryToSave(String str) {
        return ContatoFileChooserUtilities.getDirectoryToSave();
    }

    public static File getDirectoryToSave() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(0);
        fileChooser.setFileSelectionMode(1);
        String lastDir = PreferencesProperties.getInstance().getLastDir();
        if (lastDir != null) {
            File last = new File(lastDir);
            if (!last.isDirectory()) {
                last = last.getParentFile();
            }
            if (last != null) {
                fileChooser.setCurrentDirectory(last);
            }
        }
        fileChooser.setSize(ContatoFileChooserUtilities.getSize());
        fileChooser.showOpenDialog(null);
        File f = fileChooser.getSelectedFile();
        if (f == null) {
            return null;
        }
        PreferencesProperties.getInstance().setLastDir(f.getParent());
        return f;
    }
}

