/*
 * Decompiled with CFR 0.152.
 */
package datechooser.autorun;

import datechooser.beans.locale.LocaleUtils;
import datechooser.beans.pic.Pictures;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class Logo
extends JWindow {
    private static final int WIDTH = 300;
    private static final int HEIGHT = 150;
    private static final int FONT_SIZE = 16;

    public Logo() {
        this.generateInterface();
        this.setCentered();
    }

    public static JLabel createInfoLabel() {
        return Logo.createInfoLabel(true);
    }

    public static JLabel createInfoLabel(boolean text) {
        JLabel info = new JLabel();
        info.setIcon(new ImageIcon(Pictures.getResource("logo_small.gif")));
        if (text) {
            info.setText("<html>" + LocaleUtils.getConfigLocaleString("ProjectName") + "<br> (c)" + LocaleUtils.getConfigLocaleString("Author"));
        } else {
            info.setHorizontalAlignment(0);
        }
        info.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return info;
    }

    private void generateInterface() {
        JPanel mainPane = new JPanel(new BorderLayout(5, 5));
        mainPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel info = Logo.createInfoLabel();
        JProgressBar progres = new JProgressBar();
        progres.setIndeterminate(true);
        progres.setStringPainted(false);
        mainPane.add((Component)info, "Center");
        mainPane.add((Component)progres, "South");
        this.getContentPane().add(mainPane);
    }

    private void setCentered() {
        this.setSize(300, 150);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        if (300 > screenSize.width || 150 > screenSize.height) {
            this.setLocation(0, 0);
        } else {
            this.setLocation((screenSize.width - 300) / 2, (screenSize.height - 150) / 2);
        }
    }
}

