/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.border;

import datechooser.beans.editor.border.SimpleBorderEditor;
import datechooser.beans.editor.border.types.AbstractBorderEditor;
import datechooser.beans.editor.border.types.BevelBorderEditor;
import datechooser.beans.editor.border.types.CompoundBorderEditor;
import datechooser.beans.editor.border.types.EmptyBorderEditor;
import datechooser.beans.editor.border.types.EtchedBorderEditor;
import datechooser.beans.editor.border.types.LineBorderEditor;
import datechooser.beans.editor.border.types.MatteBorderEditor;
import datechooser.beans.editor.border.types.NoBorderEditor;
import datechooser.beans.editor.border.types.SoftBevelBorderEditor;
import datechooser.beans.editor.border.types.TitledBorderEditor;
import datechooser.beans.editor.utils.TextOutput;
import datechooser.beans.locale.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BorderEditorPane
extends JPanel
implements PropertyChangeListener {
    private static final int NO_BORDER_EDITOR = 0;
    private static String EMPTY = "";
    private BorderPreviewPane preview;
    private JPanel control;
    private SimpleBorderEditor editor;
    private JList selType;
    private JLabel typeName;
    private AbstractBorderEditor[] typesEditors = null;
    private int current;

    public BorderEditorPane(SimpleBorderEditor editor) {
        this.setEditor(editor);
        this.typeName = new JLabel();
        JPanel top = new JPanel(new BorderLayout());
        JPanel content = new JPanel(new GridLayout(2, 1, 1, 10));
        this.setLayout(new BorderLayout());
        this.control = new JPanel(new BorderLayout());
        top.add((Component)this.control, "Center");
        top.add((Component)this.typeName, "South");
        this.preview = new BorderPreviewPane();
        this.preview.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createEtchedBorder()));
        JButton reset = new JButton(LocaleUtils.getEditorLocaleString("Reset"));
        JPanel resetPane = new JPanel(new FlowLayout(0));
        resetPane.add(reset);
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BorderEditorPane.this.getCurrentEditor().reset();
                BorderEditorPane.this.refreshPreview();
            }
        });
        this.initEditors();
        content.add(top);
        content.add(this.preview);
        this.add((Component)content, "Center");
        this.add((Component)new JScrollPane(this.selType), "East");
        this.add((Component)resetPane, "North");
        this.revalidate();
    }

    private void initEditors() {
        this.typesEditors = new AbstractBorderEditor[]{new NoBorderEditor(), new BevelBorderEditor(), new CompoundBorderEditor(), new EmptyBorderEditor(), new EtchedBorderEditor(), new LineBorderEditor(), new MatteBorderEditor(), new SoftBevelBorderEditor(), new TitledBorderEditor()};
        this.setCurrentEditor();
        if (this.getEditor().getValue() != null) {
            this.getCurrentEditor().setCurrentBorder((Border)this.getEditor().getValue());
        }
        OnBorderChange onSelect = new OnBorderChange();
        for (AbstractBorderEditor visualEditor : this.typesEditors) {
            visualEditor.addPropertyChangeListener(onSelect);
        }
        this.selType = new JList(new EditorsListModel());
        this.selType.setCellRenderer(new TypesListRenderer());
        this.selType.setSelectedIndex(this.current);
        this.selType.setVisibleRowCount(this.typesEditors.length + 1);
        this.selType.setOpaque(false);
        this.selType.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.updateCaption();
        this.selType.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                BorderEditorPane.this.refreshEditor();
            }
        });
        this.refreshPreview();
    }

    private void refreshEditor() {
        this.setCurrentEditor(this.selType.getSelectedIndex());
        this.updateCaption();
        this.updateProperty();
        this.refreshPreview();
    }

    private AbstractBorderEditor getDefaultEditor() {
        return this.typesEditors[0];
    }

    private void updateCaption() {
        this.typeName.setText(" " + this.getCurrentEditor().getCaption());
    }

    private void updateProperty() {
        this.getEditor().setValue(this.getSelectedBorder());
    }

    private void refreshPreview() {
        this.preview.setSelectedBorder((Border)this.getEditor().getValue());
        this.preview.repaint();
    }

    private void showCurrentEditor() {
        this.control.removeAll();
        this.control.add((Component)this.getCurrentEditor(), "Center");
        this.control.revalidate();
        this.control.repaint();
    }

    private Border getSelectedBorder() {
        return this.getCurrentEditor().getSelectedBorder();
    }

    private AbstractBorderEditor getCurrentEditor() {
        return this.typesEditors[this.current];
    }

    private int getCurrentEditorIndex() {
        if (this.editor.getValue() == null) {
            return 0;
        }
        for (int i = 1; i < this.typesEditors.length; ++i) {
            Class<?> curr;
            if (this.typesEditors[i].getSelectedBorder() == null || (curr = this.typesEditors[i].getSelectedBorder().getClass()) == null || !curr.equals(this.editor.getValue().getClass())) continue;
            return i;
        }
        return 0;
    }

    private void setCurrentEditor() {
        this.setCurrentEditor(this.getCurrentEditorIndex());
    }

    private void setCurrentEditor(int index) {
        if (this.typesEditors == null) {
            return;
        }
        this.current = index < 0 || index >= this.typesEditors.length ? 0 : index;
        if (this.selType != null) {
            this.selType.setSelectedIndex(this.current);
        }
        this.showCurrentEditor();
    }

    public SimpleBorderEditor getEditor() {
        return this.editor;
    }

    public void setEditor(SimpleBorderEditor editor) {
        if (this.getEditor() != null) {
            this.getEditor().removePropertyChangeListener(this);
        }
        this.editor = editor;
        this.getEditor().addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setCurrentEditor(this.getCurrentEditorIndex());
        this.getCurrentEditor().setCurrentBorder((Border)this.editor.getValue());
        this.refreshPreview();
    }

    private AbstractBorderEditor getTypeEditor(int index) {
        if (index < 0 || index >= this.typesEditors.length) {
            return this.getDefaultEditor();
        }
        return this.typesEditors[index];
    }

    private class TypesListRenderer
    implements ListCellRenderer {
        private TypesListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = BorderEditorPane.this.getTypeEditor(index).getPreviewLabel();
            label.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            JPanel content = new JPanel(new GridLayout(1, 1));
            content.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            content.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            content.add(label);
            return content;
        }
    }

    private class OnBorderChange
    implements PropertyChangeListener {
        private OnBorderChange() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!"border".equals(evt.getPropertyName())) {
                return;
            }
            BorderEditorPane.this.updateProperty();
            BorderEditorPane.this.refreshPreview();
        }
    }

    private class BorderPreviewPane
    extends JPanel {
        private Border selectedBorder = null;

        private BorderPreviewPane() {
        }

        public Border getSelectedBorder() {
            return this.selectedBorder;
        }

        public void setSelectedBorder(Border selectedBorder) {
            this.selectedBorder = selectedBorder;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.getSelectedBorder() == null) {
                return;
            }
            Rectangle rec = this.getBounds();
            if (this.getSelectedBorder().getClass().equals(EmptyBorder.class)) {
                TextOutput.paintBoxed(g, rec, LocaleUtils.getEditorLocaleString("Invisible"));
            } else {
                this.getSelectedBorder().paintBorder(this, g, rec.width / 4, rec.height / 4, rec.width / 2, rec.height / 2);
            }
        }
    }

    class EditorsListModel
    extends AbstractListModel {
        EditorsListModel() {
        }

        public int getSize() {
            return BorderEditorPane.this.typesEditors.length;
        }

        public Object getElementAt(int index) {
            return BorderEditorPane.this.typesEditors[index];
        }
    }
}

