/*
 * Decompiled with CFR 0.152.
 */
package datechooser.beans.editor.descriptor;

import datechooser.beans.editor.descriptor.ClassDescriptor;
import datechooser.beans.editor.descriptor.DescriptionManager;
import datechooser.beans.locale.LocaleUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;

public class BorderDescriptor
extends ClassDescriptor {
    private Border value;

    public Class getDescriptedClass() {
        return Border.class;
    }

    public String getJavaDescription(Object value) {
        this.value = (Border)value;
        StringBuffer buf = new StringBuffer();
        buf.append(BorderFactory.class.getName() + ".create" + this.getJavaName(value) + "Border(");
        if (value instanceof SoftBevelBorder) {
            buf.append(this.getBevelJava());
        } else if (value instanceof BevelBorder) {
            buf.append(this.getBevelJava());
        } else if (value instanceof CompoundBorder) {
            buf.append(this.getCompoundJava());
        } else if (value instanceof MatteBorder) {
            buf.append(this.getMatteJava());
        } else if (value instanceof EmptyBorder) {
            buf.append(this.getEmptyJava());
        } else if (value instanceof EtchedBorder) {
            buf.append(this.getEtchedJava());
        } else if (value instanceof LineBorder) {
            buf.append(this.getLineJava());
        } else if (value instanceof TitledBorder) {
            buf.append(this.getTitledJava());
        }
        buf.append(")");
        return buf.toString();
    }

    public String getDescription(Object value) {
        if (value instanceof SoftBevelBorder) {
            return LocaleUtils.getEditorLocaleString("SoftBevel");
        }
        if (value instanceof BevelBorder) {
            return LocaleUtils.getEditorLocaleString("Bevel");
        }
        if (value instanceof CompoundBorder) {
            return LocaleUtils.getEditorLocaleString("Compound");
        }
        if (value instanceof MatteBorder) {
            return LocaleUtils.getEditorLocaleString("Matte");
        }
        if (value instanceof EmptyBorder) {
            return LocaleUtils.getEditorLocaleString("Empty");
        }
        if (value instanceof EtchedBorder) {
            return LocaleUtils.getEditorLocaleString("Etched");
        }
        if (value instanceof LineBorder) {
            return LocaleUtils.getEditorLocaleString("Line");
        }
        if (value instanceof TitledBorder) {
            return LocaleUtils.getEditorLocaleString("Titled");
        }
        return "?";
    }

    public String getJavaName(Object value) {
        if (value instanceof SoftBevelBorder) {
            return "SoftBevel";
        }
        if (value instanceof BevelBorder) {
            return "Bevel";
        }
        if (value instanceof CompoundBorder) {
            return "Compound";
        }
        if (value instanceof MatteBorder) {
            return "Matte";
        }
        if (value instanceof EmptyBorder) {
            return "Empty";
        }
        if (value instanceof EtchedBorder) {
            return "Etched";
        }
        if (value instanceof LineBorder) {
            return "Line";
        }
        if (value instanceof TitledBorder) {
            return "Titled";
        }
        return this.getClassName();
    }

    private String getBevelJava() {
        BevelBorder bevelValue = (BevelBorder)this.value;
        StringBuffer buf = new StringBuffer();
        buf.append(BevelBorder.class.getName() + (bevelValue.getBevelType() == 1 ? ".LOWERED" : ".RAISED"));
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(bevelValue.getHighlightOuterColor(), Color.class));
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(bevelValue.getHighlightInnerColor(), Color.class));
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(bevelValue.getShadowOuterColor(), Color.class));
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(bevelValue.getShadowInnerColor(), Color.class));
        return buf.toString();
    }

    private String getCompoundJava() {
        CompoundBorder compoundValue = (CompoundBorder)this.value;
        StringBuffer buf = new StringBuffer();
        Border out = compoundValue.getOutsideBorder();
        if (out != null) {
            buf.append(DescriptionManager.describeJava(out, out.getClass()));
        } else {
            buf.append("null");
        }
        buf.append(this.getSeparator());
        Border inside = compoundValue.getInsideBorder();
        if (inside != null) {
            buf.append(DescriptionManager.describeJava(inside, inside.getClass()));
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    private String getInsetsJava(Insets insets) {
        return "new " + Insets.class.getName() + "(" + insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right + ")";
    }

    private String getEmptyJava() {
        EmptyBorder emptyValue = (EmptyBorder)this.value;
        Insets insets = emptyValue.getBorderInsets();
        return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right;
    }

    private String getEtchedJava() {
        EtchedBorder etchedValue = (EtchedBorder)this.value;
        StringBuffer buf = new StringBuffer();
        buf.append(EtchedBorder.class.getName() + (etchedValue.getEtchType() == 1 ? ".LOWERED" : ".RAISED"));
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(etchedValue.getHighlightColor(), Color.class));
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(etchedValue.getShadowColor(), Color.class));
        return buf.toString();
    }

    private String getLineJava() {
        LineBorder lineValue = (LineBorder)this.value;
        StringBuffer buf = new StringBuffer();
        buf.append(DescriptionManager.describeJava(lineValue.getLineColor(), Color.class));
        buf.append(", ");
        buf.append(lineValue.getThickness());
        return buf.toString();
    }

    private String getMatteJava() {
        MatteBorder matteValue = (MatteBorder)this.value;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getInsetsJava(matteValue.getBorderInsets()));
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(matteValue.getMatteColor(), Color.class));
        return buf.toString();
    }

    private String getTitledJava() {
        TitledBorder titledValue = (TitledBorder)this.value;
        String className = TitledBorder.class.getName();
        StringBuffer buf = new StringBuffer();
        buf.append(DescriptionManager.describeJava(titledValue.getBorder(), Border.class));
        buf.append(this.getSeparator());
        buf.append('\"' + titledValue.getTitle() + '\"');
        buf.append(this.getSeparator());
        switch (titledValue.getTitleJustification()) {
            case 1: {
                buf.append(className + ".LEFT");
                break;
            }
            case 2: {
                buf.append(className + ".CENTER");
                break;
            }
            case 3: {
                buf.append(className + ".RIGHT");
                break;
            }
            case 4: {
                buf.append(className + ".LEADING");
                break;
            }
            case 5: {
                buf.append(className + ".TRAILING");
                break;
            }
            default: {
                buf.append(className + ".DEFAULT_JUSTIFICATION");
            }
        }
        buf.append(this.getSeparator());
        switch (titledValue.getTitlePosition()) {
            case 1: {
                buf.append(className + ".ABOVE_TOP");
                break;
            }
            case 2: {
                buf.append(className + ".TOP");
                break;
            }
            case 3: {
                buf.append(className + ".BELOW_TOP");
                break;
            }
            case 4: {
                buf.append(className + ".ABOVE_BOTTOM");
                break;
            }
            case 5: {
                buf.append(className + ".BOTTOM");
                break;
            }
            case 6: {
                buf.append(className + ".BELOW_BOTTOM");
                break;
            }
            default: {
                buf.append(className + ".DEFAULT_POSITION ");
            }
        }
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(titledValue.getTitleFont(), Font.class));
        buf.append(this.getSeparator());
        buf.append(DescriptionManager.describeJava(titledValue.getTitleColor(), Color.class));
        return buf.toString();
    }
}

