/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTextProperties;

public class ODTCellTextItem {
    private Graphics2D g2;
    private String text;
    private double resizeFactor;
    private StyleStyle textStyle;

    public ODTCellTextItem(Graphics2D graphics2D, String string, double d, StyleStyle styleStyle) {
        this.g2 = graphics2D;
        this.text = string;
        this.resizeFactor = d;
        this.textStyle = styleStyle;
    }

    public int getHeight() {
        try {
            this.g2.setFont(this.getFont());
            return this.g2.getFontMetrics().getAscent() - this.g2.getFontMetrics().getDescent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 10;
        }
    }

    public int getWidth() {
        this.g2.setFont(this.getFont());
        return this.g2.getFontMetrics().stringWidth(this.getText());
    }

    public int getWidthWithSpace() {
        this.g2.setFont(this.getFont());
        return this.g2.getFontMetrics().stringWidth(this.getText() + " ");
    }

    public Font getFont() {
        if (this.textStyle != null) {
            StyleTextProperties styleTextProperties = this.textStyle.getStyleTextProperties();
            if (styleTextProperties != null) {
                return styleTextProperties.getFont(this.resizeFactor);
            }
        } else {
            System.err.println("ODTCellTextItem:textStyle null: '" + this.getText() + "'");
        }
        return null;
    }

    public Color getColor() {
        if (this.textStyle != null) {
            StyleTextProperties styleTextProperties = this.textStyle.getStyleTextProperties();
            if (styleTextProperties != null) {
                Color color = styleTextProperties.getColor();
                if (color == null) {
                    color = Color.BLACK;
                }
                return color;
            }
        } else {
            System.err.println("ODTCellTextItem:textStyle null: '" + this.getText() + "'");
        }
        return Color.BLACK;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "TextItem:" + this.getText();
    }

    public void setText(String string) {
        this.text = string;
    }
}

