/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.examples;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.zip.ZipFile;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.PlainDocument;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.OpenOfficeSpellDictionary;
import org.dts.spell.dictionary.myspell.Utils;
import org.dts.spell.examples.utils.MemoryLabel;
import org.dts.spell.examples.utils.PefomanceSpellCheckErrorListener;
import org.dts.spell.examples.utils.StopWatch;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.finder.DocumentWordFinder;
import org.dts.spell.swing.utils.ErrorMsgBox;

public class Example8 {
    private static Icon getIcon(String name) {
        return new ImageIcon(Example8.class.getResource(name));
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Example8.init(args);
            }
        });
    }

    private static Action findAction(JTextArea textArea, String name) {
        Action[] actions = textArea.getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i].getValue("Name") != name) continue;
            KeyStroke[] accelerator = textArea.getKeymap().getKeyStrokesForAction(actions[i]);
            if (null != accelerator && accelerator.length > 0) {
                actions[i].putValue("AcceleratorKey", accelerator[0]);
            }
            return actions[i];
        }
        return null;
    }

    private static void init(String[] args) {
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            System.setProperty("sun.awt.noerasebackground", "true");
            OpenOfficeSpellDictionary dict = new OpenOfficeSpellDictionary(new ZipFile(args[0]));
            final SpellChecker checker = new SpellChecker(dict);
            final JFrame frame = new JFrame("Check Speller II");
            final JTextArea textArea = new JTextArea(25, 80);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setToolTipText("This is a tooltip");
            JPopupMenu popUpMenu = new JPopupMenu();
            popUpMenu.add(Example8.findAction(textArea, "copy-to-clipboard"));
            popUpMenu.add(Example8.findAction(textArea, "cut-to-clipboard"));
            popUpMenu.add(Example8.findAction(textArea, "paste-from-clipboard"));
            textArea.setComponentPopupMenu(popUpMenu);
            JPanel buttonPanel = new JPanel();
            final JToggleButton checkRealTimeButton = new JToggleButton("Realtime Check", Example8.getIcon("images/stock_autospellcheck.png"));
            final JTextComponentSpellChecker textSpellChecker = new JTextComponentSpellChecker(checker);
            checkRealTimeButton.setMnemonic('C');
            checkRealTimeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JToggleButton button = (JToggleButton)e.getSource();
                    if (button.isSelected()) {
                        textSpellChecker.startRealtimeMarkErrors(textArea);
                    } else {
                        textSpellChecker.stopRealtimeMarkErrors();
                    }
                    textArea.requestFocusInWindow();
                }
            });
            JButton checkButton = new JButton("Check Spell", Example8.getIcon("images/stock_spellcheck.png"));
            checkButton.setMnemonic('S');
            checkButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (textSpellChecker.spellCheck(textArea)) {
                        JOptionPane.showMessageDialog(frame, "Text is OK");
                    }
                    textArea.requestFocusInWindow();
                }
            });
            JButton checkWord = new JButton("Get Word");
            checkWord.setMnemonic('W');
            checkWord.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        DocumentWordFinder wf = new DocumentWordFinder(textArea.getDocument());
                        int caretPos = textArea.getCaretPosition();
                        Word wordAt = wf.getWordAt(caretPos);
                        Word wordPrevious = wf.getPreviousWord(caretPos);
                        Word wordNext = wf.getNextWord(caretPos);
                        JOptionPane.showMessageDialog(frame, new String[]{"Caret Pos = " + caretPos, "Previous : #" + wordPrevious + "#", "AT : #" + wordAt + "#", "Next : #" + wordNext + "#"});
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(textArea, ex.getLocalizedMessage());
                    }
                    textArea.requestFocusInWindow();
                }
            });
            JButton newButton = new JButton("New", Example8.getIcon("images/stock_new.png"));
            newButton.setMnemonic('N');
            newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (checkRealTimeButton.isSelected()) {
                        textSpellChecker.stopRealtimeMarkErrors();
                    }
                    textArea.setDocument(new PlainDocument());
                    frame.setTitle("Check Speller");
                    System.gc();
                    textArea.requestFocusInWindow();
                    if (checkRealTimeButton.isSelected()) {
                        textSpellChecker.startRealtimeMarkErrors(textArea);
                    }
                }
            });
            JButton openButton = new JButton("Open...", Example8.getIcon("images/stock_open.png"));
            openButton.setMnemonic('O');
            openButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void actionPerformed(ActionEvent e) {
                    block15: {
                        JFileChooser fileChooser = new JFileChooser();
                        if (fileChooser.showOpenDialog(textArea) == 0) {
                            if (checkRealTimeButton.isSelected()) {
                                textSpellChecker.stopRealtimeMarkErrors();
                            }
                            BufferedReader reader = null;
                            reader = new BufferedReader(new FileReader(fileChooser.getSelectedFile()));
                            textArea.read(reader, fileChooser.getSelectedFile());
                            frame.setTitle("Check Speller - " + fileChooser.getSelectedFile());
                            try {
                                Utils.close(reader);
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            System.gc();
                            textArea.requestFocusInWindow();
                            if (checkRealTimeButton.isSelected()) {
                                textSpellChecker.startRealtimeMarkErrors(textArea);
                            }
                            break block15;
                            catch (IOException ex) {
                                try {
                                    JOptionPane.showMessageDialog(textArea, ex.getLocalizedMessage());
                                    ex.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    try {
                                        Utils.close(reader);
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                    System.gc();
                                    textArea.requestFocusInWindow();
                                    if (checkRealTimeButton.isSelected()) {
                                        textSpellChecker.startRealtimeMarkErrors(textArea);
                                    }
                                    throw throwable;
                                }
                                try {
                                    Utils.close(reader);
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                System.gc();
                                textArea.requestFocusInWindow();
                                if (checkRealTimeButton.isSelected()) {
                                    textSpellChecker.startRealtimeMarkErrors(textArea);
                                }
                            }
                        }
                    }
                }
            });
            JButton chekPerfomance = new JButton("Check perfomance");
            chekPerfomance.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    StopWatch watch = new StopWatch();
                    PefomanceSpellCheckErrorListener pl = new PefomanceSpellCheckErrorListener();
                    checker.check(new DocumentWordFinder(textArea.getDocument()), pl);
                    long time = watch.stop();
                    int nErrors = pl.getErrorCount();
                    long nChars = textArea.getDocument().getLength();
                    JOptionPane.showMessageDialog(frame, String.format("Time %s for %d bad words and %d characters. (%,d characters by second)", StopWatch.getFormatedString(time), nErrors, nChars, (long)(0L == time ? 0.0 : (double)nChars / (double)time * 1000.0)));
                    frame.setCursor(Cursor.getDefaultCursor());
                }
            });
            buttonPanel.add(openButton);
            buttonPanel.add(newButton);
            buttonPanel.add(checkButton);
            buttonPanel.add(checkRealTimeButton);
            buttonPanel.add(checkWord);
            buttonPanel.add(chekPerfomance);
            frame.setDefaultCloseOperation(2);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (checkRealTimeButton.isSelected()) {
                        textSpellChecker.stopRealtimeMarkErrors();
                    }
                }
            });
            frame.add((Component)buttonPanel, "North");
            frame.add((Component)new JScrollPane(textArea), "Center");
            JPanel memoryPanel = new JPanel();
            JButton button = new JButton("GC");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.gc();
                }
            });
            memoryPanel.add(button);
            memoryPanel.add(new MemoryLabel());
            frame.add((Component)memoryPanel, "South");
            frame.pack();
            frame.setVisible(true);
            textArea.requestFocusInWindow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorMsgBox.show(ex);
        }
    }
}

