/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.examples.utils;

public class StopWatch {
    private long startTimestamp;
    private long totalTime = 0L;
    private boolean isRunning = false;

    public StopWatch() {
        this.start();
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.startTimestamp = System.currentTimeMillis();
        this.isRunning = true;
    }

    public long stop() {
        if (this.isRunning) {
            this.updateTotalTime();
            this.isRunning = false;
        }
        return this.totalTime;
    }

    public void reset() {
        this.totalTime = 0L;
        this.startTimestamp = System.currentTimeMillis();
    }

    public long split() {
        if (this.isRunning) {
            this.updateTotalTime();
        }
        return this.totalTime;
    }

    private void updateTotalTime() {
        long endTimestamp = System.currentTimeMillis();
        long elapsedTime = endTimestamp - this.startTimestamp;
        this.startTimestamp = endTimestamp;
        this.totalTime += elapsedTime;
    }

    public long getTime() {
        this.updateTotalTime();
        return this.totalTime;
    }

    public static String getFormatedString(long totalTime) {
        long millis = totalTime % 1000L;
        long seconds = (long)((double)totalTime / 1000.0);
        String totalTimeStr = millis + " ms";
        if (seconds > 0L) {
            totalTimeStr = seconds + " s " + totalTimeStr;
        }
        return totalTimeStr;
    }

    public String getTimeString() {
        long totalTime = this.getTime();
        String totalTimeStr = totalTime < 10000L ? totalTime + " ms" : (double)totalTime / 1000.0 + " s";
        return totalTimeStr;
    }
}

