/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventHandler;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import org.dts.spell.SpellChecker;
import org.dts.spell.finder.WordFinder;
import org.dts.spell.swing.JSpellPanel;
import org.dts.spell.swing.utils.Messages;

public class JSpellDialog
extends JDialog {
    private JSpellPanel panel;
    private boolean wantClose;
    private boolean cancel;
    private EscKeyProcessor escKeyProcessor = new EscKeyProcessor();

    private static String getDialogTitle() {
        return Messages.getString("JSpellDialog.TITLE");
    }

    private void init(JSpellPanel panel) {
        this.panel = panel;
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        panel.setCloseListener(EventHandler.create(ActionListener.class, this, "close"));
        panel.setCancelListener(EventHandler.create(ActionListener.class, this, "cancel"));
        panel.init();
        this.addWindowListener(this.escKeyProcessor);
        this.setDefaultCloseOperation(0);
    }

    private static Frame getCurrentFrame() {
        Frame[] frames = Frame.getFrames();
        if (null == frames || frames.length == 0) {
            return null;
        }
        return frames[frames.length - 1];
    }

    public JSpellDialog() throws HeadlessException {
        this(JSpellDialog.getCurrentFrame(), new JSpellPanel());
    }

    public JSpellDialog(JSpellPanel panel) throws HeadlessException {
        this(JSpellDialog.getCurrentFrame(), JSpellDialog.getDialogTitle(), panel);
    }

    public JSpellDialog(String title, JSpellPanel panel) throws HeadlessException {
        this(JSpellDialog.getCurrentFrame(), title, panel);
    }

    public JSpellDialog(Frame owner) throws HeadlessException {
        this(owner, new JSpellPanel());
    }

    public JSpellDialog(Frame owner, JSpellPanel panel) throws HeadlessException {
        this(owner, JSpellDialog.getDialogTitle(), panel);
    }

    public JSpellDialog(Frame owner, String title) throws HeadlessException {
        this(owner, title, new JSpellPanel());
    }

    public JSpellDialog(Frame owner, String title, JSpellPanel panel) throws HeadlessException {
        super(owner, title, true);
        this.init(panel);
    }

    public JSpellDialog(Dialog owner) throws HeadlessException {
        this(owner, new JSpellPanel());
    }

    public JSpellDialog(Dialog owner, JSpellPanel panel) throws HeadlessException {
        this(owner, JSpellDialog.getDialogTitle(), panel);
    }

    public JSpellDialog(Dialog owner, String title) throws HeadlessException {
        this(owner, title, new JSpellPanel());
    }

    public JSpellDialog(Dialog owner, String title, JSpellPanel panel) throws HeadlessException {
        super(owner, title, true);
        this.init(panel);
    }

    public void cancel() {
        this.cancel = true;
        this.close();
    }

    public void close() {
        this.wantClose = true;
        this.setVisible(false);
        this.dispose();
    }

    public boolean showDialog(SpellChecker checker, WordFinder finder) {
        this.cancel = false;
        this.wantClose = false;
        this.panel.setWrongWord(finder, checker);
        this.setModal(true);
        this.pack();
        this.setVisible(true);
        return !this.cancel;
    }

    private class EscKeyProcessor
    extends WindowAdapter
    implements KeyEventPostProcessor {
        private EscKeyProcessor() {
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                JSpellDialog.this.panel.cancel();
                return true;
            }
            return false;
        }

        public void windowClosing(WindowEvent e) {
            if (!JSpellDialog.this.wantClose) {
                JSpellDialog.this.panel.cancel();
            }
        }

        public void windowActivated(WindowEvent e) {
            KeyboardFocusManager mng = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            mng.addKeyEventPostProcessor(this);
            JSpellDialog.this.panel.initFocus();
        }

        public void windowDeactivated(WindowEvent e) {
            KeyboardFocusManager mng = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            mng.removeKeyEventPostProcessor(this);
        }
    }
}

