/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.dts.spell.SpellChecker;
import org.dts.spell.swing.RealTimeSpellChecker;
import org.dts.spell.swing.event.ErrorMarkerListener;
import org.dts.spell.swing.event.UIErrorMarkerListener;
import org.dts.spell.swing.finder.DocumentWordFinder;
import org.dts.spell.swing.utils.ErrorMarker;
import org.dts.spell.swing.utils.ErrorPopUpMenu;
import org.dts.spell.swing.utils.ErrorToolTips;

public class JTextComponentSpellChecker {
    private SpellChecker spellChecker;
    private UIErrorMarkerListener uiErrorListener = new UIErrorMarkerListener();
    private Map<JTextComponent, ErrorMarkerListener> errorMarkers = new HashMap<JTextComponent, ErrorMarkerListener>();
    private DocumentWordFinder defaultDocumentWordFinder = new DocumentWordFinder();
    private RealTimeSpellChecker realTimeSpellChecker = null;
    private ErrorToolTips errorToolTips = new ErrorToolTips();
    private ErrorPopUpMenu errorPopUpMenu = new ErrorPopUpMenu();

    public JTextComponentSpellChecker(SpellChecker checker) {
        this.spellChecker = checker;
    }

    private ErrorMarkerListener getErrorMarkerListener(JTextComponent textComponent) {
        return this.errorMarkers.get(textComponent);
    }

    public void markErrors(JTextComponent textComponent) {
        this.markErrors(textComponent, this.defaultDocumentWordFinder);
    }

    public void markErrors(JTextComponent textComponent, DocumentWordFinder wordFinder) {
        ErrorMarkerListener listener = this.getErrorMarkerListener(textComponent);
        if (null == listener) {
            listener = new ErrorMarkerListener();
            this.errorMarkers.put(textComponent, listener);
        }
        Document doc = textComponent.getDocument();
        listener.setTextComponent(textComponent);
        wordFinder.setDocument(doc);
        this.spellChecker.check(wordFinder, listener);
        if (wordFinder == this.defaultDocumentWordFinder) {
            wordFinder.quitDocument();
        }
        this.markInManagers(listener.getErrorMarker());
    }

    public void unMarkErrors(JTextComponent textComponent) {
        ErrorMarkerListener listener = this.getErrorMarkerListener(textComponent);
        if (null == listener) {
            throw new IllegalArgumentException();
        }
        listener.setTextComponent(null);
        this.errorMarkers.remove(textComponent);
        this.unMarkInManagers(listener.getErrorMarker());
    }

    public boolean spellCheck(JTextComponent textComponent) {
        return this.spellCheck(textComponent, this.defaultDocumentWordFinder);
    }

    public boolean spellCheck(JTextComponent textComponent, DocumentWordFinder documentWordFinder) {
        boolean isRealTime;
        Document doc = textComponent.getDocument();
        boolean bl = isRealTime = null != this.realTimeSpellChecker && this.realTimeSpellChecker.getDocumentWordFinder() == documentWordFinder;
        if (isRealTime) {
            this.stopRealtimeMarkErrors();
        }
        this.uiErrorListener.setTextComponent(textComponent);
        documentWordFinder.setDocument(doc);
        boolean result = this.spellChecker.check(documentWordFinder, this.uiErrorListener);
        this.uiErrorListener.quitTextComponent();
        if (!isRealTime) {
            documentWordFinder.quitDocument();
        } else {
            this.startRealtimeMarkErrors(textComponent, documentWordFinder);
        }
        return result;
    }

    public void startRealtimeMarkErrors(JTextComponent textComponent) {
        this.startRealtimeMarkErrors(textComponent, this.defaultDocumentWordFinder);
    }

    public void startRealtimeMarkErrors(JTextComponent textComponent, DocumentWordFinder wordFinder) {
        Document doc = textComponent.getDocument();
        wordFinder.setDocument(doc);
        this.realTimeSpellChecker = new RealTimeSpellChecker(this.spellChecker, textComponent, wordFinder);
        this.realTimeSpellChecker.start();
        this.markInManagers(this.realTimeSpellChecker.getErrorMarker());
    }

    public void stopRealtimeMarkErrors() {
        this.unMarkInManagers(this.realTimeSpellChecker.getErrorMarker());
        this.realTimeSpellChecker.stop();
        this.realTimeSpellChecker = null;
    }

    protected void markInManagers(ErrorMarker errorMarker) {
        if (null != this.errorToolTips) {
            this.errorToolTips.addErrorMarker(errorMarker);
        }
        if (null != this.errorPopUpMenu) {
            this.errorPopUpMenu.addErrorMarker(errorMarker);
        }
    }

    protected void unMarkInManagers(ErrorMarker errorMarker) {
        if (null != this.errorToolTips) {
            this.errorToolTips.removeErrorMarker(errorMarker);
        }
        if (null != this.errorPopUpMenu) {
            this.errorPopUpMenu.removeErrorMarker(errorMarker);
        }
    }

    public ErrorToolTips getErrorToolTips() {
        return this.errorToolTips;
    }

    public void setErrorToolTips(ErrorToolTips errorToolTips) {
        this.errorToolTips = errorToolTips;
    }

    public ErrorPopUpMenu getErrorPopUpMenu() {
        return this.errorPopUpMenu;
    }

    public void setErrorPopUpMenu(ErrorPopUpMenu errorPopUpMenu) {
        this.errorPopUpMenu = errorPopUpMenu;
    }
}

