/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.dts.spell.SpellChecker;
import org.dts.spell.event.SpellCheckListener;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.event.RealTimeSpellCheckerListener;
import org.dts.spell.swing.finder.DocumentWordFinder;
import org.dts.spell.swing.finder.SynchronizedWordFinder;
import org.dts.spell.swing.utils.ErrorMarker;
import org.dts.spell.swing.utils.TextRange;

public class RealTimeSpellChecker
implements DocumentListener,
Runnable {
    private SpellChecker spellChecker;
    private JTextComponent textComponent;
    private SynchronizedWordFinder finder;
    private List<TextRange> textRanges = new LinkedList<TextRange>();
    private volatile boolean stopThread;
    private RealTimeSpellCheckerListener listener;
    private Thread thread;

    public RealTimeSpellChecker(SpellChecker checker, JTextComponent textComponent, DocumentWordFinder finder) {
        this.spellChecker = checker;
        this.textComponent = textComponent;
        this.finder = new SynchronizedWordFinder(finder);
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public Thread getThread() {
        return this.thread;
    }

    public ErrorMarker getErrorMarker() {
        if (null != this.listener) {
            return this.listener.getErrorMarker();
        }
        return null;
    }

    public synchronized void start() {
        assert (null == this.thread);
        Document doc = this.textComponent.getDocument();
        doc.addDocumentListener(this);
        this.textRanges.add(new TextRange(doc.getStartPosition(), doc.getEndPosition()));
        this.stopThread = false;
        this.listener = new RealTimeSpellCheckerListener(this.textComponent);
        this.thread = new Thread(this);
        this.thread.setName("Spell-checker");
        this.thread.setPriority(1);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        assert (null != this.thread);
        RealTimeSpellChecker realTimeSpellChecker = this;
        synchronized (realTimeSpellChecker) {
            this.textComponent.getDocument().removeDocumentListener(this);
            this.stopThread = true;
            this.notify();
        }
        try {
            this.thread.join();
            this.thread = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void addTextRange(DocumentEvent e) {
        assert (null != this.thread);
        try {
            if (!this.textRanges.isEmpty()) {
                TextRange oldTextRange = this.textRanges.get(this.textRanges.size() - 1);
                TextRange newTextRange = oldTextRange.compactWith(e);
                if (null != newTextRange) {
                    this.textRanges.add(newTextRange);
                }
            } else {
                this.textRanges.add(new TextRange(e));
            }
            if (!this.textRanges.isEmpty()) {
                this.notify();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.addTextRange(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.addTextRange(e);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public DocumentWordFinder getDocumentWordFinder() {
        return this.finder.getWrapDocumentFinder();
    }

    private void checkRange(TextRange range, SpellCheckListener listener) {
        Word lastWord = this.finder.setTextRange(range);
        this.spellChecker.setLastWord(lastWord);
        this.spellChecker.check(this.finder, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block5: while (true) {
            try {
                while (true) {
                    TextRange range;
                    RealTimeSpellChecker realTimeSpellChecker = this;
                    synchronized (realTimeSpellChecker) {
                        if (this.textRanges.isEmpty()) {
                            this.wait();
                        }
                        if (this.stopThread) {
                            break block5;
                        }
                        range = this.textRanges.remove(0);
                    }
                    this.checkRange(range, this.listener);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        this.listener.cleanAllErrors();
    }
}

