/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.event;

import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.event.SpellCheckAdapter;
import org.dts.spell.event.SpellCheckEvent;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.utils.ErrorMarker;

public class ErrorMarkerListener
extends SpellCheckAdapter {
    private ErrorMarker errorMarker = new ErrorMarker();

    public ErrorMarkerListener() {
        this.errorMarker.setSelectError(false);
        this.errorMarker.setAutoQuit(true);
    }

    public void setTextComponent(JTextComponent textComp) {
        this.errorMarker.setTextComponent(textComp);
    }

    public JTextComponent getTextComponent() {
        return this.errorMarker.getTextComponent();
    }

    public ErrorMarker getErrorMarker() {
        return this.errorMarker;
    }

    public boolean isSelectError() {
        return this.errorMarker.isSelectError();
    }

    public void setSelectError(boolean selectError) {
        this.errorMarker.setSelectError(selectError);
    }

    public void unMarkErrors() {
        this.errorMarker.unMarkAllErrors();
    }

    public void beginChecking(SpellCheckEvent event) {
        this.unMarkErrors();
    }

    public void spellingError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getSpellingErrorInfo(event));
    }

    public void badCaseError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getBadCaseErrorInfo(event));
    }

    public void repeatWordError(SpellCheckEvent event) {
        this.markError(event, ErrorInfo.getRepeatWordErrorInfo(event));
    }

    private void markError(SpellCheckEvent event, ErrorInfo info) {
        try {
            Word word = event.getCurrentWord();
            this.errorMarker.markError(word.getStart(), word.getEnd(), info);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

